<?php $__env->startSection('title', 'Customize Home'); ?>

<?php $__env->startSection('style'); ?>
<style>
.form-label { font-weight: 600; }
.section-card { background: #ffffff; border: 1px solid #e0e0e0; border-radius: 8px; margin-bottom: 20px; }
.section-card .card-header { background: #f8f9fa; border-bottom: 1px solid #e0e0e0; padding: 12px 16px; }
.item-card { border: 1px solid #e9ecef; border-radius: 8px; padding: 12px; margin-bottom: 12px; background: #fff; }
.remove-item { cursor: pointer; color: #dc3545; }
.image-preview { width: 180px; height: 100px; border: 1px dashed #ced4da; display:flex; align-items:center; justify-content:center; border-radius:6px; overflow:hidden; background:#f8f9fa; }
.image-preview img { width: 100%; height: 100%; object-fit: cover; }
.add-btn { margin-top: 8px; }
.small-muted { font-size: 12px; color: #6c757d; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <div class="section-card">
      <div class="card-header d-flex align-items-center justify-content-between">
        <h5 class="mb-0">Home Page Customization</h5>
      </div>
      <div class="px-3 pt-2"><small class="text-muted">Hint: Use <span class="text-info">&lt;br&gt;</span> for line break where supported (e.g., slider and featured titles).</small></div>
      <div class="card-body p-3">
        <form action="<?php echo e(route('admin.customize.home.update')); ?>" method="POST" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>

          <div class="mb-3">
            <h6 class="mb-2">Sliders</h6>
            <div id="sliders-wrapper">
              <?php $sliders = $home['sliders'] ?? []; ?>
              <?php $__empty_1 = true; $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="item-card" data-index="<?php echo e($idx); ?>">
                  <div class="d-flex justify-content-between align-items-center mb-2">
                    <strong>Slide #<?php echo e($idx + 1); ?></strong>
                    <span class="remove-item" onclick="removeItem(this)"><i class="fas fa-times"></i></span>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <label class="form-label">Background Image</label>
                      <div class="image-preview mb-2">
                        <?php if(!empty($s['bg_img_path'])): ?>
                          <img src="<?php echo e(Storage::url($s['bg_img_path'])); ?>" alt="bg">
                        <?php else: ?>
                          <span class="small-muted">No image</span>
                        <?php endif; ?>
                      </div>
                      <input type="file" name="sliders[<?php echo e($idx); ?>][bg_img]" accept="image/*" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-8">
                      <div class="form-group">
                        <label class="form-label">Badge</label>
                        <input type="text" name="sliders[<?php echo e($idx); ?>][badge]" value="<?php echo e($s['badge'] ?? ''); ?>" class="form-control" placeholder="e.g. 25% off">
                      </div>
                      <div class="form-group">
                        <label class="form-label">Title</label>
                        <input type="text" name="sliders[<?php echo e($idx); ?>][title]" value="<?php echo e($s['title'] ?? ''); ?>" class="form-control" placeholder="Main title">
                      </div>
                      <div class="form-group">
                        <label class="form-label">Slogan</label>
                        <input type="text" name="sliders[<?php echo e($idx); ?>][slogan]" value="<?php echo e($s['slogan'] ?? ''); ?>" class="form-control" placeholder="Short slogan">
                      </div>
                      <div class="form-group">
                        <label class="form-label">Button Link</label>
                        <input type="url" name="sliders[<?php echo e($idx); ?>][btn_link]" value="<?php echo e($s['btn_link'] ?? ''); ?>" class="form-control" placeholder="https://...">
                      </div>
                    </div>
                  </div>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <?php endif; ?>
            </div>
            <button type="button" class="btn sb_btn btn-sm add-btn" onclick="addSlider()"><i class="fas fa-plus"></i> Add Slider</button>
          </div>

          <hr>

          <div class="mb-3">
            <h6 class="mb-2">Hero Right Boxes (Top + Two Small)</h6>
            <div id="hero-boxes-wrapper">
              <?php $heroBoxes = $home['hero_boxes'] ?? []; ?>
              <?php $__empty_1 = true; $__currentLoopData = $heroBoxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $hb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="item-card" data-index="<?php echo e($idx); ?>">
                  <div class="d-flex justify-content-between align-items-center mb-2">
                    <strong>Box #<?php echo e($idx + 1); ?></strong>
                    <span class="remove-item" onclick="removeItem(this)"><i class="fas fa-times"></i></span>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <label class="form-label">Background Image</label>
                      <div class="image-preview mb-2">
                        <?php if(!empty($hb['bg_img_path'])): ?>
                          <img src="<?php echo e(Storage::url($hb['bg_img_path'])); ?>" alt="bg">
                        <?php else: ?>
                          <span class="small-muted">No image</span>
                        <?php endif; ?>
                      </div>
                      <input type="file" name="hero_boxes[<?php echo e($idx); ?>][bg_img]" accept="image/*" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-8">
                      <div class="form-group">
                        <label class="form-label">Title</label>
                        <input type="text" name="hero_boxes[<?php echo e($idx); ?>][title]" value="<?php echo e($hb['title'] ?? ''); ?>" class="form-control" placeholder="Title">
                      </div>
                      <div class="form-group">
                        <label class="form-label">Secondary Text</label>
                        <input type="text" name="hero_boxes[<?php echo e($idx); ?>][text]" value="<?php echo e($hb['text'] ?? ''); ?>" class="form-control" placeholder="Short text">
                      </div>
                      <div class="form-group">
                        <label class="form-label">Button Link</label>
                        <input type="url" name="hero_boxes[<?php echo e($idx); ?>][btn_link]" value="<?php echo e($hb['btn_link'] ?? ''); ?>" class="form-control" placeholder="https://...">
                      </div>
                    </div>
                  </div>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <?php endif; ?>
            </div>
            <button type="button" class="btn sb_btn btn-sm add-btn" id="add-hero-box-btn" onclick="addHeroBox()"><i class="fas fa-plus"></i> Add Box</button>
          </div>

          <hr>

          <div class="mb-3">
            <h6 class="mb-2">Service Features</h6>
            <div id="services-wrapper">
              <?php $services = $home['services'] ?? []; ?>
              <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="item-card" data-index="<?php echo e($idx); ?>">
                  <div class="d-flex justify-content-between align-items-center mb-2">
                    <strong>Feature #<?php echo e($idx + 1); ?></strong>
                    <span class="remove-item" onclick="removeItem(this)"><i class="fas fa-times"></i></span>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <label class="form-label">Icon (CSS class)</label>
                      <input type="text" name="services[<?php echo e($idx); ?>][icon]" value="<?php echo e($f['icon'] ?? ''); ?>" class="form-control" placeholder="e.g. fas fa-truck">
                    </div>
                    <div class="col-md-4">
                      <label class="form-label">Title</label>
                      <input type="text" name="services[<?php echo e($idx); ?>][title]" value="<?php echo e($f['title'] ?? ''); ?>" class="form-control" placeholder="Title">
                    </div>
                    <div class="col-md-4">
                      <label class="form-label">Text</label>
                      <input type="text" name="services[<?php echo e($idx); ?>][text]" value="<?php echo e($f['text'] ?? ''); ?>" class="form-control" placeholder="Short text">
                    </div>
                  </div>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <?php endif; ?>
            </div>
            <button type="button" class="btn sb_btn btn-sm add-btn" onclick="addService()"><i class="fas fa-plus"></i> Add Feature</button>
          </div>

          <hr>

          <div class="mb-3">
            <h6 class="mb-2">Featured Section (slider)</h6>
            <div id="featured-wrapper">
              <?php $featured = $home['featured'] ?? []; ?>
              <?php $__empty_1 = true; $__currentLoopData = $featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="item-card" data-index="<?php echo e($idx); ?>">
                  <div class="d-flex justify-content-between align-items-center mb-2">
                    <strong>Item #<?php echo e($idx + 1); ?></strong>
                    <span class="remove-item" onclick="removeItem(this)"><i class="fas fa-times"></i></span>
                  </div>
                  <div class="row">
                    <div class="col-md-4">
                      <label class="form-label">Background Image</label>
                      <div class="image-preview mb-2">
                        <?php if(!empty($it['bg_img_path'])): ?>
                          <img src="<?php echo e(Storage::url($it['bg_img_path'])); ?>" alt="bg">
                        <?php else: ?>
                          <span class="small-muted">No image</span>
                        <?php endif; ?>
                      </div>
                      <input type="file" name="featured[<?php echo e($idx); ?>][bg_img]" accept="image/*" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-8">
                      <div class="form-group">
                        <label class="form-label">Title</label>
                        <input type="text" name="featured[<?php echo e($idx); ?>][title]" value="<?php echo e($it['title'] ?? ''); ?>" class="form-control" placeholder="Title">
                      </div>
                      <div class="form-group">
                        <label class="form-label">Text</label>
                        <input type="text" name="featured[<?php echo e($idx); ?>][text]" value="<?php echo e($it['text'] ?? ''); ?>" class="form-control" placeholder="Short text">
                      </div>
                      <div class="form-group">
                        <label class="form-label">Button Link</label>
                        <input type="url" name="featured[<?php echo e($idx); ?>][btn_link]" value="<?php echo e($it['btn_link'] ?? ''); ?>" class="form-control" placeholder="https://...">
                      </div>
                    </div>
                  </div>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <?php endif; ?>
            </div>
            <button type="button" class="btn sb_btn btn-sm add-btn" onclick="addFeatured()"><i class="fas fa-plus"></i> Add Featured</button>
          </div>

          <div class="text-right">
            <button type="submit" class="btn sb_btn">Save Changes</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
function removeItem(el){
  const card = el.closest('.item-card');
  card.parentNode.removeChild(card);
  // Renumber inputs after removal
  renumber('sliders-wrapper','sliders');
  renumber('services-wrapper','services');
  renumber('featured-wrapper','featured');
  renumber('hero-boxes-wrapper','hero_boxes');
  enforceHeroBoxLimit();
}

function renumber(wrapperId, field){
  const wrapper = document.getElementById(wrapperId);
  const items = wrapper.querySelectorAll('.item-card');
  items.forEach((card, idx) => {
    card.dataset.index = idx;
    card.querySelectorAll('input,select,textarea').forEach(inp => {
      const name = inp.getAttribute('name');
      if(!name) return;
      const updated = name.replace(new RegExp(field + "\\\\\\[\\\\d+\\\\]"), field + '[' + idx + ']');
      inp.setAttribute('name', updated);
    });
    const strong = card.querySelector('strong');
    if(strong) strong.textContent = strong.textContent.replace(/#\\d+/, '#' + (idx+1));
  });
}

function addSlider(){
  const wrapper = document.getElementById('sliders-wrapper');
  const idx = wrapper.querySelectorAll('.item-card').length;
  const html = `
  <div class="item-card" data-index="${idx}">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <strong>Slide #${idx + 1}</strong>
      <span class="remove-item" onclick="removeItem(this)"><i class="fas fa-times"></i></span>
    </div>
    <div class="row">
      <div class="col-md-4">
        <label class="form-label">Background Image</label>
        <input type="file" name="sliders[${idx}][bg_img]" accept="image/*" class="form-control form-control-sm">
      </div>
      <div class="col-md-8">
        <div class="form-group">
          <label class="form-label">Badge</label>
          <input type="text" name="sliders[${idx}][badge]" class="form-control" placeholder="e.g. Hot">
        </div>
        <div class="form-group">
          <label class="form-label">Title</label>
          <input type="text" name="sliders[${idx}][title]" class="form-control" placeholder="Main title">
        </div>
        <div class="form-group">
          <label class="form-label">Slogan</label>
          <input type="text" name="sliders[${idx}][slogan]" class="form-control" placeholder="Short slogan">
        </div>
        <div class="form-group">
          <label class="form-label">Button Link</label>
          <input type="url" name="sliders[${idx}][btn_link]" class="form-control" placeholder="https://...">
        </div>
      </div>
    </div>
  </div>`;
  wrapper.insertAdjacentHTML('beforeend', html);
}

function addService(){
  const wrapper = document.getElementById('services-wrapper');
  const idx = wrapper.querySelectorAll('.item-card').length;
  const html = `
  <div class="item-card" data-index="${idx}">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <strong>Feature #${idx + 1}</strong>
      <span class="remove-item" onclick="removeItem(this)"><i class="fas fa-times"></i></span>
    </div>
    <div class="row">
      <div class="col-md-4">
        <label class="form-label">Icon (CSS class)</label>
        <input type="text" name="services[${idx}][icon]" class="form-control" placeholder="e.g. fas fa-truck">
      </div>
      <div class="col-md-4">
        <label class="form-label">Title</label>
        <input type="text" name="services[${idx}][title]" class="form-control" placeholder="Title">
      </div>
      <div class="col-md-4">
        <label class="form-label">Text</label>
        <input type="text" name="services[${idx}][text]" class="form-control" placeholder="Short text">
      </div>
    </div>
  </div>`;
  wrapper.insertAdjacentHTML('beforeend', html);
}

function addFeatured(){
  const wrapper = document.getElementById('featured-wrapper');
  const idx = wrapper.querySelectorAll('.item-card').length;
  const html = `
  <div class="item-card" data-index="${idx}">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <strong>Item #${idx + 1}</strong>
      <span class="remove-item" onclick="removeItem(this)"><i class="fas fa-times"></i></span>
    </div>
    <div class="row">
      <div class="col-md-4">
        <label class="form-label">Background Image</label>
        <input type="file" name="featured[${idx}][bg_img]" accept="image/*" class="form-control form-control-sm">
      </div>
      <div class="col-md-8">
        <div class="form-group">
          <label class="form-label">Title</label>
          <input type="text" name="featured[${idx}][title]" class="form-control" placeholder="Title">
        </div>
        <div class="form-group">
          <label class="form-label">Text</label>
          <input type="text" name="featured[${idx}][text]" class="form-control" placeholder="Short text">
        </div>
        <div class="form-group">
          <label class="form-label">Button Link</label>
          <input type="url" name="featured[${idx}][btn_link]" class="form-control" placeholder="https://...">
        </div>
      </div>
    </div>
  </div>`;
  wrapper.insertAdjacentHTML('beforeend', html);
}

function addHeroBox(){
  const wrapper = document.getElementById('hero-boxes-wrapper');
  const idx = wrapper.querySelectorAll('.item-card').length;
  if(idx >= 3){ enforceHeroBoxLimit(); return; }
  const html = `
  <div class="item-card" data-index="${idx}">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <strong>Box #${idx + 1}</strong>
      <span class="remove-item" onclick="removeItem(this)"><i class="fas fa-times"></i></span>
    </div>
    <div class="row">
      <div class="col-md-4">
        <label class="form-label">Background Image</label>
        <input type="file" name="hero_boxes[${idx}][bg_img]" accept="image/*" class="form-control form-control-sm">
      </div>
      <div class="col-md-8">
        <div class="form-group">
          <label class="form-label">Title</label>
          <input type="text" name="hero_boxes[${idx}][title]" class="form-control" placeholder="Title">
        </div>
        <div class="form-group">
          <label class="form-label">Secondary Text</label>
          <input type="text" name="hero_boxes[${idx}][text]" class="form-control" placeholder="Short text">
        </div>
        <div class="form-group">
          <label class="form-label">Button Link</label>
          <input type="url" name="hero_boxes[${idx}][btn_link]" class="form-control" placeholder="https://...">
        </div>
      </div>
    </div>
  </div>`;
  wrapper.insertAdjacentHTML('beforeend', html);
  enforceHeroBoxLimit();
}

function enforceHeroBoxLimit(){
  const wrapper = document.getElementById('hero-boxes-wrapper');
  const addBtn = document.getElementById('add-hero-box-btn');
  if(!wrapper || !addBtn) return;
  const count = wrapper.querySelectorAll('.item-card').length;
  addBtn.style.display = (count >= 3) ? 'none' : '';
}

// Initialize on load
document.addEventListener('DOMContentLoaded', enforceHeroBoxLimit);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/customize/home.blade.php ENDPATH**/ ?>