

<?php $__env->startSection('title', 'Customize Contact Page'); ?>

<?php $__env->startSection('style'); ?>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<style>
.section-card { background: #ffffff; border: 1px solid #e0e0e0; border-radius: 8px; }
.item-card { border: 1px solid #e9ecef; border-radius: 8px; padding: 12px; margin-bottom: 12px; background: #fff; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <div class="section-card">
      <div class="card-header d-flex align-items-center justify-content-between">
        <h5 class="mb-0">Contact Page Customization</h5>
      </div>
      <div class="card-body p-3">
        <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.customize.contact.update')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <?php echo method_field('PUT'); ?>

          <div class="mb-3">
            <h6 class="mb-2">Contact Information</h6>
            
            <div class="item-card">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label">Address Information</label>
                    <textarea class="form-control summernote" name="address" rows="3"><?php echo e(old('address', $contact['address'])); ?></textarea>
                    <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label">Phone Numbers</label>
                    <textarea class="form-control summernote" name="phone" rows="3"><?php echo e(old('phone', $contact['phone'])); ?></textarea>
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label">Email Addresses</label>
                    <textarea class="form-control summernote" name="email" rows="3"><?php echo e(old('email', $contact['email'])); ?></textarea>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label">Google Maps Embed Code</label>
                    <textarea class="form-control" name="map_embed" rows="5" placeholder="Paste your Google Maps embed code here..."><?php echo e(old('map_embed', $contact['map_embed'])); ?></textarea>
                    <small class="form-text text-muted">Paste the complete iframe code from Google Maps embed.</small>
                    <?php $__errorArgs = ['map_embed'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="text-right">
            <button type="submit" class="btn sb_btn">Save Changes</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
<script>
$(document).ready(function() {
    $('.summernote').summernote({
        height: 150,
        toolbar: [
            ['style', ['bold', 'italic', 'underline', 'clear']],
            ['font', ['strikethrough']],
            ['para', ['ul', 'ol', 'paragraph']],
        ]
    });
});
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/customize/contact.blade.php ENDPATH**/ ?>