<?php $__env->startSection('title', 'PC Builder'); ?>
<?php $__env->startSection('style'); ?>
<style>
    .pcb-toolbar{display:flex;gap:10px;align-items:center;justify-content:space-between;margin-bottom:20px}
    .pcb-summary{font-weight:600}
    .pcb-list{border:1px solid #eee;border-radius:8px;overflow:hidden}
    .pcb-row{display:flex;align-items:center;padding:14px 12px;border-bottom:1px solid #eee;background:#fff}
    .pcb-row:last-child{border-bottom:0}
    .pcb-col-title{width:220px;display:flex;align-items:center;gap:10px}
    .pcb-required{font-size:11px;background:#f1f3f5;color:#ff6b6b;border-radius:4px;padding:2px 6px;margin-left:6px}
    .pcb-col-selected{flex:1;min-height:32px;color:#666}
    .pcb-col-actions{width:180px;text-align:right}
    .pcb-select-btn{padding:6px 12px}
    .pcb-selected-card{display:flex;align-items:center;gap:10px}
    .pcb-selected-card img{width:48px;height:48px;object-fit:cover;border-radius:6px;border:1px solid #eee}
    .pcb-price{font-weight:600;color:#111}
    .pcb-modal .modal-dialog{max-width:980px}
.pcb-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:12px}
    .pcb-card{border:1px solid #eee;border-radius:8px;overflow:hidden;background:#fff;display:flex;flex-direction:column}
.pcb-loading{display:flex;align-items:center;justify-content:center}
#pcbPagination{min-height:44px}
    .pcb-card .thumb{height:160px;background:#fafafa;display:flex;align-items:center;justify-content:center}
    .pcb-card .thumb img{max-height:100%;max-width:100%;object-fit:contain}
    .pcb-card .body{padding:10px;display:flex;flex-direction:column;gap:6px}
    .pcb-badge-out{color:#c92a2a;font-size:12px}
    .pcb-actions{display:flex;gap:8px;justify-content:flex-end}
    @media (max-width: 768px){
        .pcb-grid{grid-template-columns:repeat(2,1fr)}
        .pcb-col-actions{width:140px}
        .pcb-col-title{width:180px}
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="mn-breadcrumb m-b-30">
    <div class="row">
        <div class="col-12">
            <div class="row gi_breadcrumb_inner">
                <div class="col-md-6 col-sm-12">
                    <h2 class="mn-breadcrumb-title">PC Builder</h2>
                </div>
                <div class="col-md-6 col-sm-12">
                    <!-- mn-breadcrumb-list start -->
                    <ul class="mn-breadcrumb-list">
                        <li class="mn-breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="mn-breadcrumb-item active">PC Builder</li>
                    </ul>
                    <!-- mn-breadcrumb-list end -->
                </div>
            </div>
        </div>
    </div>
</div>
    <div class="pcb-toolbar">
        <div class="d-flex align-items-center gap-2">
            <a href="<?php echo e(route('product.cart')); ?>" class="mn-btn-1"><span><i class="ri-shopping-cart-line"></i> Go to Cart</span></a>
            <button class="mn-btn-2" id="pcbAddAll"><span><i class="ri-add-circle-line"></i> Add All to Cart</span></button>
            <button class="mn-btn-1" id="pcbReset"><span><i class="ri-refresh-line"></i> Reset</span></button>
        </div>
        <div class="pcb-summary">
            <span id="pcbSelectedCount">0</span> Selected • Total: <span id="pcbTotalPrice">৳0</span>
        </div>
    </div>

    <div class="pcb-list" id="pcbList">
        <?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="pcb-row" data-component="<?php echo e($comp['key']); ?>">
            <div class="pcb-col-title">
                <i class="ri-checkbox-blank-circle-line" style="color:#6c5ce7"></i>
                <div>
                    <div class="fw-semibold"><?php echo e($comp['label']); ?> <?php if($comp['required']): ?> <span class="pcb-required">Required</span> <?php endif; ?></div>
                </div>
            </div>
            <div class="pcb-col-selected">
                <span class="text-muted">Not selected</span>
            </div>
            <div class="pcb-col-actions">
                <button class="mn-btn-1 pcb-select-btn" data-action="choose"><span>Choose</span></button>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

<!-- Picker Modal -->
<div class="modal fade pcb-modal" id="pcbPicker" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Select <span id="pcbPickerTitle"></span></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="row mb-3">
            <div class="col-12">
                <input type="text" id="pcbSearch" class="form-control" placeholder="Search products...">
            </div>
        </div>

        <div id="pcbGrid" class="pcb-grid"></div>
        <div id="pcbPagination" class="d-flex justify-content-between align-items-center mt-3"></div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    const builderKey = 'pc_builder_selections';
    const componentCategories = <?php echo json_encode($componentCategories, 15, 512) ?>;
    let selections = JSON.parse(localStorage.getItem(builderKey) || '{}');
    let currentComponent = '';

    function saveSelections(){
        localStorage.setItem(builderKey, JSON.stringify(selections));
    }

    function formatPrice(val){
        return `৳${Number(val||0).toLocaleString()}`;
    }

    function renderRows(){
        document.querySelectorAll('#pcbList .pcb-row').forEach(row=>{
            const key = row.getAttribute('data-component');
            const selected = selections[key];
            const col = row.querySelector('.pcb-col-selected');
            const actions = row.querySelector('.pcb-col-actions');
            if(selected){
                col.innerHTML = `
                    <div class="pcb-selected-card">
                        <img src="${selected.image}" alt="${selected.title}">
                        <div>
                            <div class="fw-semibold"><a href="${selected.url}" target="_blank" class="text-decoration-none">${selected.title}</a></div>
                            <div class="pcb-price">${formatPrice(selected.price)}</div>
                        </div>
                    </div>`;
                actions.innerHTML = `
                    <button class="mn-btn-1 pcb-select-btn" data-action="change"><span>Change</span></button>
                    <button class="mn-btn-1 pcb-select-btn" data-action="remove"><span>Remove</span></button>`;
            }else{
                col.innerHTML = `<span class="text-muted">Not selected</span>`;
                actions.innerHTML = `<button class="mn-btn-1 pcb-select-btn" data-action="choose"><span>Choose</span></button>`;
            }
        });
        updateSummary();
        bindRowButtons();
    }

    function updateSummary(){
        const items = Object.values(selections);
        const count = items.length;
        const total = items.reduce((sum,i)=> sum + (Number(i.price)||0), 0);
        document.getElementById('pcbSelectedCount').textContent = count;
        document.getElementById('pcbTotalPrice').textContent = formatPrice(total);
        document.getElementById('pcbAddAll').disabled = count === 0;
    }

    function bindRowButtons(){
        document.querySelectorAll('#pcbList .pcb-row .pcb-select-btn').forEach(btn=>{
            btn.onclick = (e)=>{
                const row = e.currentTarget.closest('.pcb-row');
                const key = row.getAttribute('data-component');
                const action = e.currentTarget.getAttribute('data-action');
                if(action === 'remove'){
                    delete selections[key];
                    saveSelections();
                    renderRows();
                    return;
                }
                openPicker(key);
            };
        });
    }

    function openPicker(key){
        currentComponent = key;
        const titleNode = document.querySelector(`.pcb-row[data-component="${key}"] .fw-semibold`);
        const headerTitle = document.getElementById('pcbPickerTitle');
        if (titleNode && headerTitle) {
            // Keep the small "Required" badge styling by using innerHTML from the row title
            headerTitle.innerHTML = titleNode.innerHTML;
        }
        const modal = new bootstrap.Modal(document.getElementById('pcbPicker'));
        modal.show();
        // reset search
        const searchEl = document.getElementById('pcbSearch');
        if (searchEl) searchEl.value = '';
        // populate categories based on component
        // category filter removed; component already scopes results
        loadProducts(1);
    }

    function loadProducts(page=1){
        const grid = document.getElementById('pcbGrid');
        const pagination = document.getElementById('pcbPagination');
        const q = document.getElementById('pcbSearch').value.trim();
        const categoryId = '';
        grid.innerHTML = '<div class="pcb-loading py-4"><div class="spinner-border text-primary" role="status"></div></div>';
        pagination.innerHTML = '<div class="w-100 d-flex justify-content-between align-items-center" style="visibility:hidden;">\
            <button class="mn-btn-1"><span><i class="ri-arrow-left-s-line"></i> Prev</span></button>\
            <div class="text-muted">&nbsp;</div>\
            <button class="mn-btn-1"><span>Next <i class="ri-arrow-right-s-line"></i></span></button>\
        </div>';
        const url = new URL(`<?php echo e(route('pc.builder.products')); ?>`);
        url.searchParams.set('component', currentComponent);
        if(q) url.searchParams.set('q', q);
        // category filter removed
        url.searchParams.set('page', page);
        url.searchParams.set('per_page', 5);
        fetch(url.toString(), {headers:{'X-Requested-With':'XMLHttpRequest'}})
            .then(r=>r.json())
            .then(data=>{
                grid.innerHTML = '';
                if(!data.items || !data.items.length){
                    grid.innerHTML = '<div class="text-center text-muted py-5">No products found</div>';
                    // still render invisible placeholder rows to prevent modal border jumping
                    for(let i=0;i<3;i++){
                        const ph = document.createElement('div');
                        ph.style.visibility = 'hidden';
                        ph.innerHTML = '<div class="pcb-card" style="height:0"></div>';
                        grid.appendChild(ph);
                    }
                    return;
                }
                data.items.forEach(item=>{
                    const out = (item.in_stock||0) <= 0 || !item.default_variant_id;
                    const card = document.createElement('div');
                    card.className = 'pcb-card';
                    card.innerHTML = `
                        <div class="thumb"><img src="${item.image}" alt="${item.title}"></div>
                        <div class="body">
                            <div class="fw-semibold" style="min-height:42px">${item.title}</div>
                            <div class="d-flex justify-content-between align-items-center">
                                <div>${out?'<span class="pcb-badge-out">Out of stock</span>':`<span class="pcb-price">${formatPrice(item.price)}</span>`}</div>
                                <div class="pcb-actions">
                                    <a href="${item.url}" target="_blank" class="mn-btn-1"><span>View</span></a>
                                    <button class="mn-btn-2 select-product" ${out?'disabled':''}><span>Select</span></button>
                                </div>
                            </div>
                        </div>`;
                    card.querySelector('.select-product')?.addEventListener('click', ()=>{
                        selections[currentComponent] = {
                            productId: String(item.id),
                            variantId: String(item.default_variant_id||''),
                            title: item.title,
                            price: item.price,
                            image: item.image,
                            url: item.url
                        };
                        saveSelections();
                        bootstrap.Modal.getInstance(document.getElementById('pcbPicker')).hide();
                        renderRows();
                    });
                    grid.appendChild(card);
                });

                // Pagination
                const meta = data.meta || {current_page:1,last_page:1};
                const btnPrev = document.createElement('button');
                btnPrev.className = 'mn-btn-1';
                btnPrev.innerHTML = '<span><i class="ri-arrow-left-s-line"></i> Prev</span>';
                btnPrev.disabled = meta.current_page <= 1;
                btnPrev.onclick = ()=> loadProducts(meta.current_page - 1);

                const btnNext = document.createElement('button');
                btnNext.className = 'mn-btn-1';
                btnNext.innerHTML = '<span>Next <i class="ri-arrow-right-s-line"></i></span>';
                btnNext.disabled = meta.current_page >= meta.last_page;
                btnNext.onclick = ()=> loadProducts(meta.current_page + 1);

                const info = document.createElement('div');
                info.className = 'text-muted';
                info.textContent = `Page ${meta.current_page} of ${meta.last_page}`;

                pagination.appendChild(btnPrev);
                pagination.appendChild(info);
                pagination.appendChild(btnNext);
            })
            .catch(()=>{
                grid.innerHTML = '<div class="text-center text-danger py-5">Failed to load products</div>';
            });
    }

    // Debounced live search: start after key is released and user pauses typing
    let pcbSearchDebounce;
    const pcbSearchEl = document.getElementById('pcbSearch');
    pcbSearchEl.addEventListener('keyup', function(){
        clearTimeout(pcbSearchDebounce);
        pcbSearchDebounce = setTimeout(()=> loadProducts(1), 300);
    });

    document.getElementById('pcbAddAll').addEventListener('click', function(){
        const items = Object.values(selections);
        if(!items.length){return;}
        let added = 0, skipped = 0;
        items.forEach(i=>{
            try {
                if (typeof isProductInCart === 'function' && isProductInCart(i.productId)) {
                    skipped++;
                } else if (typeof addToCart === 'function') {
                    addToCart(String(i.productId), String(i.variantId), 1, false);
                    added++;
                }
            } catch(e) {}
        });
        showNotification(`${added} item(s) added${skipped?`, ${skipped} skipped (already in cart)`:''}`, 'success');
    });

    document.getElementById('pcbReset').addEventListener('click', function(){
        selections = {};
        saveSelections();
        renderRows();
    });

    // Initialize
    renderRows();
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('general_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/general/pc_builder.blade.php ENDPATH**/ ?>