<?php $__env->startSection("title", "Contact Us"); ?>
<?php $__env->startSection("style"); ?>
<style>
    .contact-section {
        padding: 30px 0 80px 0;
    }
    .contact-info-box {
        background: #fff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0,0,0,0.05);
        margin-bottom: 30px;
        transition: transform 0.3s ease;
    }
    .contact-info-box:hover {
        transform: translateY(-5px);
    }
    .contact-info-box i {
        font-size: 2.5rem;
        color: #159abe;
        margin-bottom: 20px;
    }
    .contact-form {
        background: #fff;
        padding: 40px;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0,0,0,0.05);
        height: 100%;
    }
    .form-control {
        border: 1px solid #e1e1e1;
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 5px;
    }
    .form-control:focus {
        border-color: #159abe;
        box-shadow: none;
    }
    .btn-submit {
        background: #159abe;
        color: #fff;
        padding: 15px 30px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        transition: background 0.3s ease;
    }
    .btn-submit:hover {
        background: #2c3bb3;
    }
    .map-container {
        height: 100%;
        min-height: 600px;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 0 20px rgba(0,0,0,0.05);
    }
    .section-title {
        margin-bottom: 50px;
        text-align: center;
    }
    .section-title h2 {
        font-size: 2.5rem;
        color: #333;
        margin-bottom: 15px;
    }
    .section-title p {
        color: #666;
        font-size: 1.1rem;
    }
    .equal-height {
        height: 100%;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
<div class="contact-section">
    <div class="container">
        <div class="section-title">
            <h2>Get in Touch</h2>
            <p>We're here to help and answer any questions you might have</p>
        </div>
        
        <div class="row">
            <div class="col-md-4">
                <div class="contact-info-box text-center">
                    <i class="ri-map-pin-line"></i>
                    <h4>Visit Us</h4>
                    <?php echo $contact['address'] ?? ''; ?>

                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-info-box text-center">
                    <i class="ri-phone-line"></i>
                    <h4>Call Us</h4>
                    <?php echo $contact['phone'] ?? ''; ?>

                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-info-box text-center">
                    <i class="ri-mail-line"></i>
                    <h4>Email Us</h4>
                    <?php echo $contact['email'] ?? ''; ?>

                </div>
            </div>
        </div>

        <div class="row mt-5">
            <div class="col-lg-6">
                <div class="map-container">
                    <?php echo $contact['map_embed'] ?? ''; ?>

                </div>
            </div>
            <div class="col-lg-6">
                <div class="contact-form">
                    <h3 class="mb-4">Send us a Message</h3>
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    
                    <form action="<?php echo e(route('contact.submit')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="name" placeholder="Your Name" value="<?php echo e(old('name')); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="email" placeholder="Your Email" value="<?php echo e(old('email')); ?>" required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <input type="tel" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="phone" placeholder="Phone Number" value="<?php echo e(old('phone')); ?>" required>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <select class="form-control <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="type" required>
                                    <option value="">Select One</option>
                                    <option value="general" <?php echo e(old('type') == 'general' ? 'selected' : ''); ?>>General Inquiry</option>
                                    <option value="order" <?php echo e(old('type') == 'order' ? 'selected' : ''); ?>>Order Status & Issues</option>
                                    <option value="return" <?php echo e(old('type') == 'return' ? 'selected' : ''); ?>>Return & Refund</option>
                                    <option value="account" <?php echo e(old('type') == 'account' ? 'selected' : ''); ?>>Account & Login</option>
                                    
                                    <option value="feedback" <?php echo e(old('type') == 'feedback' ? 'selected' : ''); ?>>Feedback & Suggestions</option>
                                    <option value="complaint" <?php echo e(old('type') == 'complaint' ? 'selected' : ''); ?>>File a Complaint</option>
                                </select>
                                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <textarea class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                            name="message" rows="5" placeholder="Your Message" required><?php echo e(old('message')); ?></textarea>
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        
                        <div class="mb-3">
                            <?php echo NoCaptcha::renderJs(); ?>

                            <?php echo NoCaptcha::display(); ?>

                        </div>
                        <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger mb-3"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        
                        <button type="submit" class="btn mn-btn-2" style="padding: 18px 40px; font-size: 1.1rem;"><span>Send Message</span></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/general/contact.blade.php ENDPATH**/ ?>