<?php $__env->startSection('title', $blog->title); ?>
<?php $__env->startSection('style'); ?>
<style>
.mn-blog-post-container {
    display: grid;
    grid-template-columns: 1fr 350px;
    gap: 30px;
}
.mn-blog-main {
    background: white;
    padding: 25px 20px;
    border-radius: 8px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}
.mn-blog-sidebar {
    background: white;
    border-radius: 8px;
    padding: 25px;
    height: fit-content;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    margin-right: 30px;
}
.mn-blog-sidebar-title {
    font-size: 1.5rem;
    color: #333;
    margin-bottom: 25px;
    font-weight: 600;
}
.mn-recent-post {
    display: flex;
    gap: 15px;
    margin-bottom: 20px;
    text-decoration: none;
}
.mn-recent-post:last-child {
    margin-bottom: 0;
}
.mn-recent-post-img {
    width: 100px;
    height: 70px;
    border-radius: 8px;
    overflow: hidden;
    flex-shrink: 0;
}
.mn-recent-post-img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.mn-recent-post-info {
    flex-grow: 1;
}
.mn-recent-post-title {
    font-size: 0.95rem;
    color: #333;
    line-height: 1.4;
    font-weight: 500;
    margin-bottom: 5px;
}
.mn-recent-post-meta {
    font-size: 0.85rem;
    color: #666;
    margin-bottom: 3px;
}
.mn-recent-post-category {
    color: var(--primary);
    font-size: 0.85rem;
}
.mn-blog-post-meta {
    margin-bottom: 15px;
    font-size: 0.95rem;
}
.mn-blog-post-meta span {
    color: #666;
}
.mn-blog-post-meta a {
    color: var(--primary);
    text-decoration: none;
    margin-left: 5px;
}
.mn-blog-post-title {
    font-size: 2rem;
    color: #333;
    margin-bottom: 20px;
    line-height: 1.3;
}
.mn-blog-post-image {
    width: 100%;
    border-radius: 10px;
    overflow: hidden;
    margin-bottom: 25px;
}
.mn-blog-post-image img {
    width: 100%;
    height: auto;
}
.mn-blog-post-content {
    color: #666;
    line-height: 1.8;
    font-size: 1.1rem;
}
.mn-blog-post-content p {
    margin-bottom: 20px;
}
.mn-blog-post-content p.highlight {
    font-style: italic;
    color: #555;
    padding: 15px 0;
    border-left: 3px solid var(--primary);
    padding-left: 20px;
    margin: 20px 0;
}
.mn-blog-post-stats {
    display: flex;
    gap: 20px;
    margin: 30px 0;
}
.mn-blog-post-stat {
    display: flex;
    align-items: center;
    gap: 8px;
    color: #666;
    cursor: pointer;
}
.mn-blog-post-stat.active {
    color: var(--primary);
}
.mn-blog-post-stat i {
    font-size: 1.2rem;
}
.mn-blog-post-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin-bottom: 30px;
}
.mn-blog-post-tag {
    color: #666;
    font-size: 0.9rem;
    text-decoration: none;
}
.mn-blog-post-tag:hover {
    color: var(--primary);
}
.mn-blog-comments {
    margin-top: 50px;
    border-top: 1px solid #eee;
    padding-top: 30px;
}
.mn-blog-comments-title {
    font-size: 1.2rem;
    color: #333;
    margin-bottom: 20px;
}
.mn-comment-form {
    margin-bottom: 30px;
}
.mn-comment-form textarea {
    width: 100%;
    padding: 15px;
    border: 1px solid #dee2e6;
    border-radius: 10px;
    resize: vertical;
    min-height: 100px;
}
.mn-comment-form button {
    margin-top: 15px;
    padding: 8px 20px;
    background: var(--primary);
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
}
.mn-blog-interactions {
    display: flex;
    align-items: center;
    gap: 8px;
    margin: 20px 0;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 8px;
}
.mn-blog-interaction-btn {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    border: 1px solid #e0e0e0;
    border-radius: 20px;
    background: white;
    color: #666;
    cursor: pointer;
    transition: all 0.2s ease;
    text-decoration: none;
    font-size: 0.9rem;
}
.mn-blog-interaction-btn:hover {
    background: #f5f5f5;
    transform: translateY(-1px);
}
.mn-blog-interaction-btn.active {
    border-color: currentColor;
    background: rgba(var(--bs-primary-rgb), 0.1);
}
.mn-blog-interaction-btn.like.active {
    color: #0d6efd;
}
.mn-blog-interaction-btn.love.active {
    color: #dc3545;
}
.mn-blog-interaction-btn.happy.active {
    color: #ffc107;
}
.mn-blog-interaction-btn.angry.active {
    color: #fd7e14;
}
.mn-blog-interaction-btn.sad.active {
    color: #6c757d;
}
.mn-blog-interaction-btn .emoji {
    font-size: 1.2rem;
    line-height: 1;
}
.mn-blog-interaction-btn span.count {
    font-weight: 500;
    min-width: 8px;
    text-align: center;
}
.mn-blog-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    margin-bottom: 30px;
}
.mn-blog-tag {
    color: #666;
    font-size: 0.9rem;
    padding: 4px 12px;
    border-radius: 15px;
    background: #f8f9fa;
    text-decoration: none;
}
.mn-blog-tag:hover {
    color: var(--primary);
    background: rgba(var(--primary-rgb), 0.1);
}
.mn-blog-comments {
    margin-top: 40px;
}
.mn-blog-comments-title {
    font-size: 1.2rem;
    color: #333;
    margin-bottom: 25px;
    font-weight: 600;
}
.mn-comment-form {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 30px;
}
.mn-comment-form-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 15px;
}
.mn-comment-form-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #e9ecef;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}
.mn-comment-form-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.mn-comment-form-avatar i {
    font-size: 1.4rem;
    color: #adb5bd;
}
.mn-comment-form-title {
    font-size: 1.1rem;
    color: #333;
    font-weight: 500;
}
.mn-comment-form textarea {
    width: 100%;
    padding: 15px;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    resize: vertical;
    min-height: 100px;
    background: white;
    margin-bottom: 15px;
    font-size: 0.95rem;
}
.mn-comment-form textarea:focus {
    outline: none;
    border-color: #0d6efd;
}
.mn-comment-form-actions {
    display: flex;
    justify-content: flex-end;
    gap: 10px;
}
.mn-comment-form button {
    padding: 10px 24px;
    background: #0d6efd;
    color: white;
    border: none;
    border-radius: 20px;
    cursor: pointer;
    font-weight: 500;
    font-size: 0.95rem;
    display: flex;
    align-items: center;
    gap: 8px;
}
.mn-comment-form button:hover {
    background: #0b5ed7;
}
.mn-comment-form button:disabled {
    background: #6c757d;
    opacity: 0.7;
    cursor: not-allowed;
    box-shadow: none;
}
.mn-comment-form button i {
    font-size: 1.2rem;
    color: white;
}
.mn-comment {
    margin-bottom: 25px;
    padding-bottom: 25px;
    border-bottom: 1px solid #eee;
}
.mn-comment:last-child {
    margin-bottom: 0;
    padding-bottom: 0;
    border-bottom: none;
}
.mn-comment-header {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 10px;
    font-size: 0.95rem;
}
.mn-comment-header > div:last-child {
    display: flex;
    align-items: center;
    gap: 4px;
}
.mn-comment-header time {
    font-size: 0.85rem;
    color: #666;
}
.mn-comment-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    overflow: hidden;
}
.mn-comment-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.mn-comment-info {
    flex-grow: 1;
}
.mn-comment-author {
    font-weight: 500;
    color: #333;
    margin-bottom: 2px;
}
.mn-comment-date {
    font-size: 0.9rem;
    color: #666;
}
.mn-comment-content {
    color: #444;
    line-height: 1.6;
    margin-bottom: 8px;
    margin-left: 48px;
}
.mn-comment-actions {
    display: flex;
    gap: 12px;
    margin-left: 48px;
}
.mn-comment-action {
    font-size: 0.9rem;
    color: #666;
    cursor: pointer;
    transition: color 0.2s;
}
.mn-comment-action:hover {
    color: #0d6efd;
}
.mn-comment-replies {
    margin-left: 55px;
    margin-top: 20px;
    padding-top: 20px;
    border-top: 1px solid #eee;
}

.login-alert {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: white;
    padding: 30px;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    text-align: center;
    z-index: 1000;
    min-width: 320px;
    max-width: 90%;
}
.login-alert h3 {
    font-size: 1.3rem;
    color: #333;
    margin-bottom: 12px;
    font-weight: 600;
}
.login-alert p {
    color: #666;
    margin-bottom: 25px;
    font-size: 1rem;
    line-height: 1.5;
}
.login-alert-buttons {
    display: flex;
    gap: 12px;
    justify-content: center;
}
.login-alert-button {
    padding: 10px 24px;
    border-radius: 8px;
    cursor: pointer;
    font-size: 0.95rem;
    font-weight: 500;
    border: none;
    transition: all 0.2s;
}
.login-alert-button.primary {
    background: #0d6efd;
    color: white;
}
.login-alert-button.primary:hover {
    background: #0b5ed7;
    transform: translateY(-1px);
}
.login-alert-button.secondary {
    background: #f0f2f5;
    color: #444;
}
.login-alert-button.secondary:hover {
    background: #e4e6eb;
}
.login-alert-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.5);
    z-index: 999;
}

@media (max-width: 991px) {
    .mn-blog-post-container {
        grid-template-columns: 1fr;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="mn-blog-post-container">
    <article class="mn-blog-main">
        <div class="mn-blog-post-meta">
            <?php echo e($blog->created_at->format('F d, Y')); ?> - <a href="#"><?php echo e($blog->category ?? 'Fashion'); ?></a>
        </div>

        <h1 class="mn-blog-post-title"><?php echo e($blog->title); ?></h1>

        <div class="mn-blog-post-image">
            <img src="<?php echo e(asset('storage/' . $blog->thumbnail)); ?>" alt="<?php echo e($blog->title); ?>">
        </div>

        <div class="mn-blog-post-content">
            <?php echo $blog->content; ?>

        </div>

        <div class="mn-blog-interactions">
            <?php if(auth()->guard()->check()): ?>
                <?php $__currentLoopData = App\Models\BlogReaction::REACTIONS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $reaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button 
                        class="mn-blog-interaction-btn <?php echo e($type); ?> <?php echo e($userReaction === $type ? 'active' : ''); ?>" 
                        onclick="react('<?php echo e($type); ?>')"
                        style="<?php echo e($userReaction === $type ? 'color: ' . App\Models\BlogReaction::getReactionColor($type) : ''); ?>"
                    >
                        <span class="emoji"><?php echo e($reaction['emoji']); ?></span>
                        <span class="count" id="<?php echo e($type); ?>-count"><?php echo e($blog->reactions()->where('reaction_type', $type)->count()); ?></span>
                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <?php $__currentLoopData = App\Models\BlogReaction::REACTIONS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $reaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button 
                        class="mn-blog-interaction-btn <?php echo e($type); ?>"
                        onclick="showLoginAlert()"
                    >
                        <span class="emoji"><?php echo e($reaction['emoji']); ?></span>
                        <span class="count"><?php echo e($blog->reactions()->where('reaction_type', $type)->count()); ?></span>
                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>

        <?php if($blog->tags): ?>
        <div class="mn-blog-tags">
            <?php $__currentLoopData = $blog->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="#" class="mn-blog-tag">#<?php echo e($tag); ?></a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php endif; ?>

        <div class="mn-blog-comments">
            <h3 class="mn-blog-comments-title">Comments (<?php echo e($blog->comments->count()); ?>)</h3>
            
            <?php if(auth()->guard()->check()): ?>
            <div class="mn-comment-form">
                <div class="mn-comment-form-header">
                    <div class="mn-comment-form-avatar">
                        <?php if(auth()->user()->avatar): ?>
                            <img src="<?php echo e(asset('storage/' . auth()->user()->avatar)); ?>" alt="<?php echo e(auth()->user()->name); ?>">
                        <?php else: ?>
                            <i class="ri-user-line"></i>
                        <?php endif; ?>
                    </div>
                    <div class="mn-comment-form-title">Write a comment as <?php echo e(auth()->user()->name); ?></div>
                </div>
                <form onsubmit="submitComment(event)">
                    <textarea placeholder="Share your thoughts..." required></textarea>
                    <div class="mn-comment-form-actions">
                        <button type="submit">
                            <i class="ri-send-plane-line"></i>
                            Post Comment
                        </button>
                    </div>
                </form>
            </div>
            <?php else: ?>
            <div class="mn-comment-form" style="text-align: center;">
                <div class="mn-comment-form-header" style="justify-content: center;">
                    <div class="mn-comment-form-avatar">
                        <i class="ri-user-line"></i>
                    </div>
                </div>
                <p style="margin: 15px 0;">Please <a href="<?php echo e(route('login')); ?>" style="color: var(--primary); text-decoration: none; font-weight: 500;">login</a> to join the discussion.</p>
            </div>
            <?php endif; ?>

            <div id="comments-container">
                <?php $__currentLoopData = $blog->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make('blog.partials.comment', ['comment' => $comment], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </article>

    <aside class="mn-blog-sidebar">
        <h3 class="mn-blog-sidebar-title">Recent Articles</h3>
        <?php $__currentLoopData = $recentBlogs->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentBlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route('blog.show', $recentBlog->slug)); ?>" class="mn-recent-post">
            <div class="mn-recent-post-img">
                <img src="<?php echo e(asset('storage/' . $recentBlog->thumbnail)); ?>" alt="<?php echo e($recentBlog->title); ?>">
            </div>
            <div class="mn-recent-post-info">
                <h4 class="mn-recent-post-title"><?php echo e($recentBlog->title); ?></h4>
                <div class="mn-recent-post-meta"><?php echo e($recentBlog->created_at->format('F d, Y')); ?></div>
            </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </aside>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
function submitComment(event) {
    event.preventDefault();
    const form = event.target;
    const textarea = form.querySelector('textarea');
    const button = form.querySelector('button');
    
    if (!textarea.value.trim()) return;
    
    button.disabled = true;
    button.textContent = 'Posting...';
    
    fetch('<?php echo e(route("blog.comment", $blog->id)); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ comment: textarea.value })
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById('comments-container').insertAdjacentHTML('afterbegin', data.comment);
        textarea.value = '';
        // Update comment count
        const countEl = document.querySelector('.mn-blog-comments-title');
        const count = parseInt(countEl.textContent.match(/\d+/)[0]) + 1;
        countEl.textContent = `Comments (${count})`;
    })
    .catch(error => console.error('Error:', error))
    .finally(() => {
        button.disabled = false;
        button.textContent = 'Post Comment';
    });
}

function deleteComment(commentId) {
    if (!confirm('Are you sure you want to delete this comment?')) return;

    fetch(`/blog/comment/${commentId}`, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Remove the comment element
            const commentEl = document.querySelector(`[data-comment-id="${commentId}"]`);
            commentEl.remove();
            // Update comment count
            const countEl = document.querySelector('.mn-blog-comments-title');
            const count = parseInt(countEl.textContent.match(/\d+/)[0]) - 1;
            countEl.textContent = `Comments (${count})`;
        }
    })
    .catch(error => console.error('Error:', error));
}

function replyToComment(commentId) {
    // Find any existing reply forms and remove them
    const existingForms = document.querySelectorAll('.reply-form');
    existingForms.forEach(form => form.remove());

    // Get the comment element
    const commentEl = document.querySelector(`[data-comment-id="${commentId}"]`);
    
    // Create reply form
    const replyForm = document.createElement('div');
    replyForm.className = 'mn-comment-form reply-form';
    replyForm.innerHTML = `
        <div class="mn-comment-form-header">
            <div class="mn-comment-form-avatar">
                <i class="ri-user-3-line"></i>
            </div>
        </div>
        <form onsubmit="submitReply(event, '${commentId}')">
            <textarea placeholder="Write your reply..." required></textarea>
            <div class="mn-comment-form-actions">
                <button type="submit">Post Reply</button>
            </div>
        </form>
    `;

    // Insert after the comment actions
    const actionsEl = commentEl.querySelector('.mn-comment-actions');
    actionsEl.insertAdjacentElement('afterend', replyForm);
}

function submitReply(event, commentId) {
    event.preventDefault();
    const form = event.target;
    const textarea = form.querySelector('textarea');
    const button = form.querySelector('button');
    
    if (!textarea.value.trim()) return;
    
    button.disabled = true;
    button.textContent = 'Posting...';
    
    fetch(`/blog/comment/${commentId}/reply`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ comment: textarea.value })
    })
    .then(response => response.json())
    .then(data => {
        const commentEl = document.querySelector(`[data-comment-id="${commentId}"]`);
        let repliesContainer = commentEl.querySelector('.mn-comment-replies');
        
        if (!repliesContainer) {
            repliesContainer = document.createElement('div');
            repliesContainer.className = 'mn-comment-replies';
            commentEl.appendChild(repliesContainer);
        }
        
        repliesContainer.insertAdjacentHTML('beforeend', data.reply);
        form.parentElement.remove();
    })
    .catch(error => console.error('Error:', error))
    .finally(() => {
        button.disabled = false;
        button.textContent = 'Post Reply';
    });
}

function react(type) {
    const url = type === '<?php echo e($userReaction); ?>' 
        ? '<?php echo e(route("blog.react.remove", $blog->id)); ?>'
        : '<?php echo e(route("blog.react", $blog->id)); ?>';

    fetch(url, {
        method: type === '<?php echo e($userReaction); ?>' ? 'DELETE' : 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json'
        },
        body: type === '<?php echo e($userReaction); ?>' ? null : JSON.stringify({ type: type })
    })
    .then(response => response.json())
    .then(data => {
        // Update all reaction counts
        Object.keys(data.reactions).forEach(reactionType => {
            const countEl = document.getElementById(`${reactionType}-count`);
            if (countEl) countEl.textContent = data.reactions[reactionType];
        });
        
        // Update active states and colors
        document.querySelectorAll('.mn-blog-interaction-btn').forEach(btn => {
            btn.classList.remove('active');
            btn.style.color = '';
        });

        if (type !== '<?php echo e($userReaction); ?>') {
            const activeBtn = document.querySelector(`.mn-blog-interaction-btn.${type}`);
            if (activeBtn) {
                activeBtn.classList.add('active');
                activeBtn.style.color = '<?php echo e(App\Models\BlogReaction::getReactionColor("' + type + '")); ?>';
            }
        }
    })
    .catch(error => console.error('Error:', error));
}

function showLoginAlert() {
    // Create overlay
    const overlay = document.createElement('div');
    overlay.className = 'login-alert-overlay';
    document.body.appendChild(overlay);

    // Create alert
    const alert = document.createElement('div');
    alert.className = 'login-alert';
    alert.innerHTML = `
        <h3>Join the Conversation! 🎉</h3>
        <p>Sign in to share your reaction and be part of our community.</p>
        <div class="login-alert-buttons">
            <button onclick="window.location.href='<?php echo e(route('login')); ?>'" class="login-alert-button primary">Sign In</button>
            <button onclick="closeLoginAlert()" class="login-alert-button secondary">Close</button>
        </div>
    `;
    document.body.appendChild(alert);

    // Close on overlay click
    overlay.addEventListener('click', closeLoginAlert);
}

function closeLoginAlert() {
    const overlay = document.querySelector('.login-alert-overlay');
    const alert = document.querySelector('.login-alert');
    if (overlay) overlay.remove();
    if (alert) alert.remove();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('general_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/blog/post.blade.php ENDPATH**/ ?>