<?php $__env->startSection('title', 'Categories'); ?>

<?php $__env->startSection('style'); ?>
<style>
.category-icon {
    width: 40px;
    height: 40px;
    object-fit: cover;
}
.add-btn {
    margin-bottom: 20px;
}
.subcategory {
    margin-left: 30px;
    position: relative;
    padding-left: 20px;
    border-left: 2px solid #e9ecef;
}
.subcategory:before {
    content: '↳';
    position: absolute;
    left: 0;
    color: #6c757d;
}
.department-badge {
    font-size: 0.8rem;
    padding: 3px 8px;
    border-radius: 12px;
}
.department-badge.medical {
    background-color:rgb(38, 173, 197);
    color: #ffffff;
}
.department-badge.general {
    background-color: #28a745;
    color: #ffffff;
}
.preview-image {
    max-width: 100px;
    max-height: 100px;
    margin-top: 10px;
    border-radius: 4px;
}
.table-actions {
    display: flex;
    gap: 8px;
    justify-content: center;
}
.table-actions button {
    border: none;
    padding: 6px 12px;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.2s;
}
.edit-btn {
    background-color: #ffc107;
    color: #000;
}
.edit-btn:hover {
    background-color: #e0a800;
}
.delete-btn {
    background-color: #dc3545;
    color: white;
}
.delete-btn:hover {
    background-color: #c82333;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Categories</h3>
    </div>
    <div class="card-body">
        <button class="sb_btn add-btn" onclick="showAddModal()">
            <i class="fas fa-plus"></i> Add New Category
        </button>

        <div class="table-responsive">
            <table id="categoriesTable" class="table table-bordered table-striped">
                <thead class="bg_sb_primary">
                    <tr>
                        <th class="text-center">#</th>
                        <th class="text-center">Icon</th>
                        <th>Name</th>
                        
                        <th class="text-center">Products</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        // Group categories by parent
                        $groupedCategories = $categories->groupBy('parent_id');
                        
                        // Closure to render categories recursively (prevents function redeclaration across compiled views)
                        $renderCategories = function($groupedCategories, $parentId = null) use (&$renderCategories) {
                            if (!isset($groupedCategories[$parentId])) return '';

                            $html = '';
                            foreach ($groupedCategories[$parentId] as $category) {
                                $html .= '<tr>';
                                $html .= '<td class="text-center"></td>';
                                $iconHtml = '';
                                if (!$parentId && $category->icon) {
                                    $iconHtml = '<img src="' . asset('storage/' . $category->icon) . '" alt="' . e($category->name) . '" class="category-icon">';
                                }
                                $html .= '<td class="text-center">' . $iconHtml . '</td>';
                                $html .= '<td>' . ($parentId ? '<div class="subcategory">' . e($category->name) . '</div>' : e($category->name)) . '</td>';
                                $html .= '<td class="text-center">' . $category->products->count() . '</td>';
                                $html .= '<td class="text-center">';
                                $html .= '  <div class="table-actions">';
                                $html .= '    <button class="edit-btn" onclick="showEditModal(' . $category->id . ')"><i class="fas fa-edit"></i></button>';
                                $html .= '    <button class="delete-btn" onclick="showDeleteModal(' . $category->id . ', \'' . e($category->name) . '\')"><i class="fas fa-trash"></i></button>';
                                $html .= '  </div>';
                                $html .= '</td>';
                                $html .= '</tr>';

                                if (isset($groupedCategories[$category->id])) {
                                    $html .= $renderCategories($groupedCategories, $category->id);
                                }
                            }
                            return $html;
                        };
                    ?>
                    
                    <?php echo $renderCategories($groupedCategories); ?>

                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add/Edit Category Modal -->
<div class="modal fade" id="categoryModal" tabindex="-1" role="dialog" aria-labelledby="categoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg_sb_primary">
                <h5 class="modal-title" id="categoryModalLabel">Add New Category</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="categoryForm" onsubmit="saveCategory(event)" enctype="multipart/form-data">
                <div class="modal-body">
                    <input type="hidden" id="categoryId">
                    
                    <div class="form-group">
                        <label for="name" class="required">Name</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>

                    <div class="form-group">
                        <label for="parent_id">Parent Category</label>
                        <select class="form-control" id="parent_id" name="parent_id" onchange="handleParentChange()">
                            <option value="">None (Top Level Category)</option>
                            <?php $__currentLoopData = $parentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($parent->id); ?>">
                                    <?php echo e($parent->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    

                    <div class="form-group" id="iconGroup">
                        <label for="icon" class="required">Icon</label>
                        <input type="file" class="form-control" id="icon" name="icon" 
                               accept="image/png,image/jpeg,image/jpg,image/svg+xml">
                        <small class="form-text text-muted">
                            Supported formats: PNG, JPEG, SVG. Max size: 2MB
                        </small>
                        <div id="iconPreview" class="mt-2"></div>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-between p-1">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times"></i> Cancel
                    </button>
                    <button type="submit" class="sb_btn">
                        <i class="fas fa-save"></i> <span id="saveButtonText">Save Category</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete category: <strong id="deleteCategoryName"></strong>?
                <br>
                <small class="text-danger">This action cannot be undone!</small>
            </div>
            <div class="modal-footer d-flex justify-content-between p-1">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i> Cancel
                </button>
                <button type="button" class="btn btn-danger" onclick="deleteCategory()">
                    <i class="fas fa-trash"></i> Delete Category
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    $('#categoriesTable').DataTable({
        responsive: true,
        pageLength: 20
    });
});

let categoryIdToDelete = null;

function handleParentChange() {
    const parentSelect = document.getElementById('parent_id');
    const isSubCategory = !!parentSelect.value;

    // Toggle icon field: subcategories don't need icons
    const iconGroup = document.getElementById('iconGroup');
    const iconInput = document.getElementById('icon');
    if (isSubCategory) {
        iconGroup.style.display = 'none';
        iconInput.required = false;
        // Clear selected file and preview when hiding
        iconInput.value = '';
        document.getElementById('iconPreview').innerHTML = '';
    } else {
        iconGroup.style.display = '';
        // Only require icon for ADD, not for EDIT (edit sets required elsewhere)
        const isEdit = !!document.getElementById('categoryId').value;
        iconInput.required = !isEdit;
    }

    $('#categoryModalLabel').text($('#categoryId').val() ? 'Edit Subcategory' : 'Add New Category');
    $('#saveButtonText').text($('#categoryId').val() ? 'Update Subcategory' : 'Save Category');
}

function showAddModal() {
    $('#categoryId').val('');
    $('#categoryForm')[0].reset();
    $('#iconPreview').empty();
    // Initialize icon required for top-level by default, will be adjusted by handleParentChange
    const iconInput = document.getElementById('icon');
    iconInput.required = true;
    handleParentChange();

    // Update modal title and button text based on parent selection
    const parentSelect = document.getElementById('parent_id');
    if (parentSelect.value) {
        $('#categoryModalLabel').text('Add New Subcategory');
        $('#saveButtonText').text('Save Subcategory');
    } else {
        $('#categoryModalLabel').text('Add New Category');
        $('#saveButtonText').text('Save Category');
    }
    
    $('#categoryModal').modal('show');
}

function showEditModal(categoryId) {
    const categories = <?php echo json_encode($categories, 15, 512) ?>;
    const category = categories.find(c => c.id === categoryId);
    
    $('#categoryId').val(categoryId);
    $('#name').val(category.name);
    $('#parent_id').val(category.parent_id || '');
    
    // Update modal title based on parent
    if (category.parent_id) {
        $('#categoryModalLabel').text('Edit Subcategory');
        $('#saveButtonText').text('Update Subcategory');
    } else {
        $('#categoryModalLabel').text('Edit Category');
        $('#saveButtonText').text('Update Category');
    }
    
    // For edit, icon upload is optional; hide icon group if subcategory
    const iconInput = document.getElementById('icon');
    iconInput.required = false;
    const iconGroup = document.getElementById('iconGroup');
    if (category.parent_id) {
        iconGroup.style.display = 'none';
        $('#iconPreview').empty();
    } else {
        iconGroup.style.display = '';
        // Show current icon
        $('#iconPreview').html(`
        <img src="<?php echo e(asset('storage')); ?>/${category.icon}" class="preview-image">
        <input type="hidden" name="current_icon" value="${category.icon}">
    `);
    }
    
    $('#categoryModal').modal('show');
}

// Preview uploaded image
document.getElementById('icon').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            $('#iconPreview').html(`
                <img src="${e.target.result}" class="preview-image">
            `);
        }
        reader.readAsDataURL(file);
    }
});

function saveCategory(event) {
    event.preventDefault();
    
    const categoryId = $('#categoryId').val();
    const isEdit = categoryId !== '';
    const url = isEdit 
        ? `/admin/categories/${categoryId}`
        : '/admin/categories';
    const method = isEdit ? 'PUT' : 'POST';
    
    const formData = new FormData(document.getElementById('categoryForm'));
    if (isEdit) {
        formData.append('_method', 'PUT');
    }

    fetch(url, {
        method: isEdit ? 'POST' : method, // For PUT requests with FormData
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        $('#categoryModal').modal('hide');
        if (data.success) {
            window.location.href = "<?php echo e(route('admin.categories')); ?>?success=" + data.message;
        } else {
            window.location.href = "<?php echo e(route('admin.categories')); ?>?error=" + data.message;
        }
    })
    .catch(error => {
        $('#categoryModal').modal('hide');
        window.location.href = "<?php echo e(route('admin.categories')); ?>?error=Error saving category";
    });
}

function showDeleteModal(categoryId, categoryName) {
    categoryIdToDelete = categoryId;
    $('#deleteCategoryName').text(categoryName);
    $('#deleteModal').modal('show');
}

function deleteCategory() {
    if (categoryIdToDelete) {
        fetch(`/admin/categories/${categoryIdToDelete}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            $('#deleteModal').modal('hide');
            if (data.success) {
                window.location.href = "<?php echo e(route('admin.categories')); ?>?success=Category deleted successfully";
            } else {
                window.location.href = "<?php echo e(route('admin.categories')); ?>?error=" + data.message;
            }
        })
        .catch(error => {
            $('#deleteModal').modal('hide');
            window.location.href = "<?php echo e(route('admin.categories')); ?>?error=Error deleting category";
        });
    }
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/categories/list.blade.php ENDPATH**/ ?>