<!DOCTYPE html>
<html>
<head>
    <title>New Comment on Blog - <?php echo e($comment->blog->title); ?></title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0;">
    <div style="max-width: 800px; margin: 0 auto; padding: 20px;">
        <h2>New Comment on Blog Post</h2>
        
        <div style="background-color: #f9f9f9; padding: 20px; border-radius: 4px; margin: 20px 0;">
            <div style="background-color: white; padding: 15px; border-radius: 4px; margin: 15px 0;">
                <p style="margin: 0;"><strong>Blog Post:</strong> <?php echo e($comment->blog->title); ?></p>
                <p style="margin: 5px 0;"><strong>Comment Date:</strong> <?php echo e($comment->created_at->format('M d, Y H:i:s')); ?></p>
                <p style="margin: 5px 0;"><strong>Comment Type:</strong> 
                    <?php if($comment->parent_id): ?>
                        <span style="color: #2196F3; font-weight: bold;">Reply to Comment</span>
                    <?php else: ?>
                        <span style="color: #4CAF50; font-weight: bold;">New Comment</span>
                    <?php endif; ?>
                </p>
            </div>

            <div style="margin-top: 20px;">
                <p><strong>Commenter Details:</strong></p>
                <table style="width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 8px 0; width: 150px;"><strong>Name:</strong></td>
                        <td style="padding: 8px 0;"><?php echo e($comment->user->name ?? 'Guest User'); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; width: 150px;"><strong>Email:</strong></td>
                        <td style="padding: 8px 0;"><?php echo e($comment->user->email ?? 'N/A'); ?></td>
                    </tr>
                    <?php if($comment->parent_id): ?>
                    <tr>
                        <td style="padding: 8px 0; width: 150px;"><strong>Replying to:</strong></td>
                        <td style="padding: 8px 0;">Comment #<?php echo e($comment->parent_id); ?></td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>

            <div style="margin-top: 20px;">
                <p><strong>Comment Content:</strong></p>
                <div style="background-color: white; padding: 15px; border-radius: 4px; border-left: 4px solid #2196F3;">
                    <p style="margin: 0; font-style: italic;">"<?php echo e($comment->comment); ?>"</p>
                </div>
            </div>

            <div style="margin-top: 20px;">
                <p><strong>Blog Post Summary:</strong></p>
                <div style="background-color: white; padding: 15px; border-radius: 4px;">
                    <p style="margin: 0;"><strong>Title:</strong> <?php echo e($comment->blog->title); ?></p>
                    <p style="margin: 5px 0;"><strong>Author:</strong> <?php echo e($comment->blog->author->name ?? 'Unknown'); ?></p>
                    <p style="margin: 5px 0;"><strong>Published:</strong> <?php echo e($comment->blog->created_at->format('M d, Y')); ?></p>
                    <p style="margin: 5px 0;"><strong>Total Comments:</strong> <?php echo e($comment->blog->comments->count()); ?></p>
                </div>
            </div>

            <div style="margin-top: 20px;">
                <p>
                    <a href="<?php echo e(url(route('admin.blogs.comments'))); ?>" style="display: inline-block; padding: 10px 20px; background-color: #4CAF50; color: white; text-decoration: none; border-radius: 4px; margin-right: 10px;">View All Comments</a>
                    <a href="<?php echo e(url(route('admin.blogs.edit', $comment->blog->id))); ?>" style="display: inline-block; padding: 10px 20px; background-color: #2196F3; color: white; text-decoration: none; border-radius: 4px;">Edit Blog Post</a>
                </p>
            </div>
        </div>
        
        <p style="color: #666; font-size: 14px;">This is an automated notification from <?php echo e(config('app.name')); ?></p>
    </div>
</body>
</html> <?php /**PATH /home/techmind/public_html/resources/views/emails/admin/new-blog-comment.blade.php ENDPATH**/ ?>