<?php $__env->startSection("title", "Two-Factor Authentication"); ?>

<?php $__env->startSection("style"); ?>
<style>
.auth-wrapper {
    padding: 30px 0;
}
.auth-card {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 0 20px rgba(0,0,0,0.05);
    padding: 25px;
    text-align: center;
    max-width: 400px;
    margin: 0 auto;
}
.auth-logo {
    width: 42px;
    height: 42px;
    background: #4263eb;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 15px;
}
.auth-logo i {
    font-size: 20px;
    color: #fff;
}
.auth-title {
    color: #313b50;
    margin-bottom: 8px;
    font-size: 18px;
    font-weight: 500;
}
.auth-subtitle {
    color: #666;
    margin-bottom: 20px;
    font-size: 13px;
}
.otp-input {
    text-align: center;
    letter-spacing: 0.5em;
    font-size: 18px;
    padding: 10px;
    margin-bottom: 15px;
    border: 1px solid #e5e5e5;
    border-radius: 8px;
    background: #fff;
}
.otp-input:focus {
    border-color: #4263eb;
    box-shadow: 0 0 0 3px rgba(66, 99, 235, 0.1);
    outline: none;
}
.verify-btn {
    background: #4263eb;
    color: #fff;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    position: relative;
    overflow: hidden;
    z-index: 1;
    margin-bottom: 13px;
}
.verify-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #ffe3a3;
    transform: translateX(-100%);
    transition: transform 0.3s ease;
    z-index: -1;
}
.verify-btn:hover {
    color: #000;
}
.verify-btn:hover::before {
    transform: translateX(0);
}
.verify-btn i {
    margin-right: 6px;
    font-size: 16px;
}
.recovery-link {
    color: #4263eb;
    text-decoration: none;
    font-size: 13px;
    margin-top: 15px;
    display: inline-block;
    cursor: pointer;
}
.recovery-link:hover {
    text-decoration: underline;
}

/* Modal Styles */
.modal-content {
    border: none;
    border-radius: 10px;
}
.modal-header {
    padding: 15px 20px 10px;
}
.modal-header .modal-title {
    font-size: 16px;
    font-weight: 500;
}
.modal-body {
    padding: 15px 20px;
}
.modal-body .text-muted {
    font-size: 13px;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
<div class="auth-wrapper">
    <div class="auth-card">
        <div class="auth-logo">
            <i class="ri-shield-keyhole-line"></i>
        </div>
        <h4 class="auth-title">Two-Factor Authentication</h4>
        <p class="auth-subtitle" id="formSubtitle">Please enter the verification code from your authenticator app</p>

        <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="alert alert-danger mb-3">
                <?php echo e($message); ?>

            </div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        <form action="<?php echo e(route('security.2fa.verify.post')); ?>" method="POST" class="otp-form" id="otpForm">
            <?php echo csrf_field(); ?>
            <input type="text" class="form-control otp-input" 
                   name="code" required maxlength="6" autofocus autocomplete="off"
                   id="otpInput">
            <button type="submit" class="verify-btn">
                <i class="ri-shield-check-line"></i> Verify
            </button>
        </form>

        <a href="javascript:void(0)" class="recovery-link" data-bs-toggle="modal" data-bs-target="#recoveryModal">
            Lost access to your authenticator app?
        </a>
    </div>
</div>

<!-- Recovery Code Modal -->
<div class="modal fade" id="recoveryModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title">Recovery Code Verification</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center px-4 pb-4">
                <p class="text-muted mb-4">Enter one of your recovery codes to verify your identity</p>
                
                <form action="<?php echo e(route('security.2fa.verify.post')); ?>" method="POST" id="recoveryForm">
                    <?php echo csrf_field(); ?>
                    <input type="text" class="form-control otp-input" 
                           name="code" required maxlength="10" autocomplete="off"
                           placeholder="Enter recovery code"
                           id="recoveryInput">
                    <button type="submit" class="verify-btn mt-3">
                        <i class="ri-key-2-line"></i> Verify Recovery Code
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Handle numeric input for OTP
    document.getElementById('otpInput').addEventListener('input', function(e) {
        this.value = this.value.replace(/[^0-9]/g, '');
        if (this.value.length > 6) {
            this.value = this.value.slice(0, 6);
        }
    });

    // Handle alphanumeric input for recovery code
    document.getElementById('recoveryInput').addEventListener('input', function(e) {
        if (this.value.length > 10) {
            this.value = this.value.slice(0, 10);
        }
    });

    // Focus recovery input when modal shows
    document.getElementById('recoveryModal').addEventListener('shown.bs.modal', function() {
        document.getElementById('recoveryInput').focus();
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/auth/verify-2fa.blade.php ENDPATH**/ ?>