<?php $__env->startSection("title", "My Orders"); ?>
<?php $__env->startSection("style"); ?>
<?php echo $__env->make('partial.user_styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
.mn-order-table {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0,0,0,0.05);
    overflow: hidden;
}

.mn-order-table table {
    width: 100%;
}

.mn-order-table th {
    background: #f8f9fa;
    padding: 15px 20px;
    font-weight: 600;
    text-align: left;
    color: #4a5568;
    border-bottom: 1px solid #eee;
}

.mn-order-table td {
    padding: 15px 20px;
    border-bottom: 1px solid #eee;
    color: #4a5568;
    vertical-align: middle;
}

.mn-order-table tr:last-child td {
    border-bottom: none;
}

.mn-order-table .order-id {
    font-weight: 600;
    color: #4a5568;
    font-family: monospace;
    font-size: 1.1rem;
    letter-spacing: 0.5px;
}

.mn-order-table .order-date {
    color: #718096;
    font-size: 0.8rem;
}

.mn-order-table .order-total {
    font-weight: 500;
    color: #4a5568;
}

.mn-order-table .order-status {
    display: inline-flex;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 500;
}

.mn-order-table .status-pending {
    background: #fff8e1;
    color: #b45309;
}

.mn-order-table .status-processing {
    background: #e8f5e9;
    color: #1b5e20;
}

.mn-order-table .status-shipped {
    background: #e3f2fd;
    color: #0d47a1;
}

.mn-order-table .status-delivered {
    background: #f3e8ff;
    color: #6b21a8;
}

.mn-order-table .status-cancelled {
    background: #fee2e2;
    color: #991b1b;
}

.mn-order-table .status-info {
    background: #e0f2f1;
    color: #004d40;
}

.mn-order-table .status-verified {
    background: #f3e8ff;
    color: #6b21a8;
}

.mn-order-table .status-rejected {
    background: #fee2e2;
    color: #991b1b;
}

.mn-order-table .payment-note {
    display: block;
    margin-top: 5px;
    font-size: 0.8rem;
    color: #dc2626;
}

/* Remove the old button style */
.btn-view-invoice {
    display: none;
}

/* Add styles for mn-btn-1 in the table */
.mn-order-table .mn-btn-1 {
    padding: 6px 12px;
    font-size: 0.85rem;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.mn-order-table .mn-btn-1 i {
    font-size: 1rem;
}

.empty-orders {
    text-align: center;
    padding: 40px 20px;
}

.empty-orders i {
    font-size: 48px;
    color: #a0aec0;
    margin-bottom: 15px;
}

.empty-orders h5 {
    color: #2d3748;
    margin-bottom: 10px;
}

.empty-orders p {
    color: #718096;
    margin-bottom: 20px;
}

@media (max-width: 768px) {
    .mn-order-table {
        display: block;
        overflow-x: auto;
    }
    
    .mn-order-table table {
        min-width: 800px;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
<div class="container account-wrapper">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            <?php echo $__env->make('partial.user_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="account-content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="mb-0">My Orders</h4>
                    <span class="text-muted"><?php echo e($orders->total()); ?> orders</span>
                </div>

                <?php if($orders->isEmpty()): ?>
                    <div class="empty-orders">
                        <i class="ri-shopping-bag-3-line"></i>
                        <h5>No Orders Yet</h5>
                        <p>You haven't placed any orders yet. Start shopping to place your first order!</p>
                        <a href="<?php echo e(route('product.list')); ?>" class="mn-btn-2">
                            <span>Start Shopping</span>
                        </a>
                    </div>
                <?php else: ?>
                    <div class="mn-order-table">
                        <table>
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>Date</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>Payment</th>
                                    <th>Invoice</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="order-id"><?php echo e($order->order_number); ?></td>
                                    <td class="order-date"><?php echo e($order->created_at->format('M d, Y')); ?><br><?php echo e($order->created_at->format('h:i A')); ?></td>
                                    <td class="order-total">৳<?php echo e(number_format($order->total)); ?></td>
                                    <td>
                                        <span class="order-status status-<?php echo e(strtolower($order->order_status)); ?>">
                                            <?php if($order->order_status === 'pending'): ?>
                                                Pending
                                            <?php elseif($order->order_status === 'processing'): ?>
                                                Processing
                                            <?php elseif($order->order_status === 'shipped'): ?>
                                                Shipped
                                            <?php elseif($order->order_status === 'delivered'): ?>
                                                Delivered
                                            <?php else: ?>
                                                <?php echo e(ucfirst($order->order_status)); ?>

                                            <?php endif; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if($order->payment_method === 'cod'): ?>
                                            <span class="order-status status-info">Cash on Delivery</span>
                                        <?php else: ?>
                                            <span class="order-status status-<?php echo e($order->payment_status === 'paid' ? 'verified' : ($order->payment_status === 'failed' ? 'rejected' : ($order->payment_status === 'cancelled' ? 'cancelled' : 'pending'))); ?>">
                                                Digital Payment (<?php echo e(ucfirst($order->payment_status ?? 'unpaid')); ?>)
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('product.order.invoice', $order->order_number)); ?>" 
                                           class="mn-btn-1">
                                            <span><i class="ri-file-list-3-line"></i> View Invoice</span>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if($orders->hasPages()): ?>
                        <?php echo $__env->make('partial.pagination', ['paginator' => $orders], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/user/orders.blade.php ENDPATH**/ ?>