<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\GeneralController;
use App\Http\Controllers\CompareController;
use App\Http\Controllers\PcBuilderController;

// General Routes
Route::get('/', [GeneralController::class, 'home'])->name('home');
Route::get('/best-deals', [GeneralController::class, 'bestDeals'])->name('best.deals');
Route::get('/p/{slug}', [GeneralController::class, 'page'])->name('page');
Route::get('/faq', [GeneralController::class, 'faq'])->name('faq');

// PC Builder
Route::get('/pc-builder', [PcBuilderController::class, 'index'])->name('pc.builder');
Route::get('/pc-builder/products', [PcBuilderController::class, 'products'])->name('pc.builder.products');

// Contact Routes
Route::get('/contact', [GeneralController::class, 'contact'])->name('contact');
Route::post('/contact/submit', [GeneralController::class, 'submitContact'])->name('contact.submit');

// user dashboard
Route::middleware('auth', 'verified', 'active')->group(function () {
    Route::get('/notifications', [GeneralController::class, 'notifications'])->name('notifications');
    Route::get('/referral', [GeneralController::class, 'referral'])->name('referral');
    Route::get('/ranking', [GeneralController::class, 'ranking'])->name('ranking');
});

// Wholesaler feature removed

Route::get('/compare', [CompareController::class, 'index'])->name('compare');
Route::post('/compare/products', [CompareController::class, 'getProducts'])->name('compare.products');