@extends("general_base")
@section("title", "My Orders")
@section("style")
@include('partial.user_styles')
<style>
.mn-order-table {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0,0,0,0.05);
    overflow: hidden;
}

.mn-order-table table {
    width: 100%;
}

.mn-order-table th {
    background: #f8f9fa;
    padding: 15px 20px;
    font-weight: 600;
    text-align: left;
    color: #4a5568;
    border-bottom: 1px solid #eee;
}

.mn-order-table td {
    padding: 15px 20px;
    border-bottom: 1px solid #eee;
    color: #4a5568;
    vertical-align: middle;
}

.mn-order-table tr:last-child td {
    border-bottom: none;
}

.mn-order-table .order-id {
    font-weight: 600;
    color: #4a5568;
    font-family: monospace;
    font-size: 1.1rem;
    letter-spacing: 0.5px;
}

.mn-order-table .order-date {
    color: #718096;
    font-size: 0.8rem;
}

.mn-order-table .order-total {
    font-weight: 500;
    color: #4a5568;
}

.mn-order-table .order-status {
    display: inline-flex;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 500;
}

.mn-order-table .status-pending {
    background: #fff8e1;
    color: #b45309;
}

.mn-order-table .status-processing {
    background: #e8f5e9;
    color: #1b5e20;
}

.mn-order-table .status-shipped {
    background: #e3f2fd;
    color: #0d47a1;
}

.mn-order-table .status-delivered {
    background: #f3e8ff;
    color: #6b21a8;
}

.mn-order-table .status-cancelled {
    background: #fee2e2;
    color: #991b1b;
}

.mn-order-table .status-info {
    background: #e0f2f1;
    color: #004d40;
}

.mn-order-table .status-verified {
    background: #f3e8ff;
    color: #6b21a8;
}

.mn-order-table .status-rejected {
    background: #fee2e2;
    color: #991b1b;
}

.mn-order-table .payment-note {
    display: block;
    margin-top: 5px;
    font-size: 0.8rem;
    color: #dc2626;
}

/* Remove the old button style */
.btn-view-invoice {
    display: none;
}

/* Add styles for mn-btn-1 in the table */
.mn-order-table .mn-btn-1 {
    padding: 6px 12px;
    font-size: 0.85rem;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.mn-order-table .mn-btn-1 i {
    font-size: 1rem;
}

.empty-orders {
    text-align: center;
    padding: 40px 20px;
}

.empty-orders i {
    font-size: 48px;
    color: #a0aec0;
    margin-bottom: 15px;
}

.empty-orders h5 {
    color: #2d3748;
    margin-bottom: 10px;
}

.empty-orders p {
    color: #718096;
    margin-bottom: 20px;
}

@media (max-width: 768px) {
    .mn-order-table {
        display: block;
        overflow-x: auto;
    }
    
    .mn-order-table table {
        min-width: 800px;
    }
}
</style>
@endsection

@section("content")
<div class="container account-wrapper">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            @include('partial.user_sidebar')
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="account-content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="mb-0">My Orders</h4>
                    <span class="text-muted">{{ $orders->total() }} orders</span>
                </div>

                @if($orders->isEmpty())
                    <div class="empty-orders">
                        <i class="ri-shopping-bag-3-line"></i>
                        <h5>No Orders Yet</h5>
                        <p>You haven't placed any orders yet. Start shopping to place your first order!</p>
                        <a href="{{ route('product.list') }}" class="mn-btn-2">
                            <span>Start Shopping</span>
                        </a>
                    </div>
                @else
                    <div class="mn-order-table">
                        <table>
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>Date</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>Payment</th>
                                    <th>Invoice</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($orders as $order)
                                <tr>
                                    <td class="order-id">{{ $order->order_number }}</td>
                                    <td class="order-date">{{ $order->created_at->format('M d, Y') }}<br>{{ $order->created_at->format('h:i A') }}</td>
                                    <td class="order-total">৳{{ number_format($order->total) }}</td>
                                    <td>
                                        <span class="order-status status-{{ strtolower($order->order_status) }}">
                                            @if($order->order_status === 'pending')
                                                Pending
                                            @elseif($order->order_status === 'processing')
                                                Processing
                                            @elseif($order->order_status === 'shipped')
                                                Shipped
                                            @elseif($order->order_status === 'delivered')
                                                Delivered
                                            @else
                                                {{ ucfirst($order->order_status) }}
                                            @endif
                                        </span>
                                    </td>
                                    <td>
                                        @if($order->payment_method === 'cod')
                                            <span class="order-status status-info">Cash on Delivery</span>
                                        @else
                                            <span class="order-status status-{{ $order->payment_status === 'paid' ? 'verified' : ($order->payment_status === 'failed' ? 'rejected' : ($order->payment_status === 'cancelled' ? 'cancelled' : 'pending')) }}">
                                                Digital Payment ({{ ucfirst($order->payment_status ?? 'unpaid') }})
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('product.order.invoice', $order->order_number) }}" 
                                           class="mn-btn-1">
                                            <span><i class="ri-file-list-3-line"></i> View Invoice</span>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($orders->hasPages())
                        @include('partial.pagination', ['paginator' => $orders])
                    @endif
                @endif
            </div>
        </div>
    </div>
</div>
@endsection 