@extends("general_base")
@section("title", "Our Products")
@section("style")
<style>
    .mn-sidebar-block-item {
        display: flex;
        align-items: center;
        gap: 8px;
    }
    .mn-sidebar-block-item input[type="radio"],
    .mn-sidebar-block-item input[type="checkbox"] {
        margin: 0;
    }
    .price-range-item,
    .size-filter-item {
        margin-bottom: -10px;
    }
    .brands-wrap {
        gap: 10px;
    }
    .brand-logo-mini {
        width: auto;
        max-width: 40px;
        height: 35px;
        object-fit: contain;
        border-radius: 4px;
        border: 1px solid #eee;
        background: #fff;
    }
    .mn-card-meta { display:flex; align-items:center; justify-content:space-between; margin:-4px 0 6px 0; }
    .mn-card-rating { display:inline-flex; align-items:center; gap:4px; font-size:14px; }
    .mn-card-rating .num { color:#666; }
    .mn-product-card .mn-product-detail .cat a { text-transform: none !important; }

    .mn-sidebar-block.drop .mn-sb-block-content ul li .main.drop:after {
        content: '' !important;
    }
</style>
@endsection
@section("content")
<div class="row">
    <div class="col-xxl-12">
        <!-- Shop section -->
        <section class="mn-shop">
            <div class="row">
                <!-- Sidebar Area Start -->
                <div class="filter-sidebar-overlay"></div>
                <div class="mn-shop-sidebar mn-filter-sidebar col-lg-3 col-md-12">
                    <div id="shop_sidebar">
                        <div class="mn-sidebar-wrap">
                            <!-- Sidebar Filters Block -->
                            <div class="mn-sidebar-block drop">
                                <div class="mn-sb-title">
                                    <h3 class="mn-sidebar-title">Filters</h3>
                                    <a href="javascript:void(0)" class="filter-close"><i class="ri-close-large-line"></i></a>
                                </div>
                                @php
                                    $currentCategory = request('category');
                                @endphp
                                @foreach($categories as $category)
                                <div class="mn-sb-block-content">
                                            <ul>
                                                <li>
                                                    <a href="javascript:void(0)" 
                                                        data-category="{{ $category->slug }}"
                                                        class="mn-sidebar-block-item main {{ $category->hasChildren() ? 'drop' : '' }} {{ request('category') == $category->slug ? 'active' : '' }}"
                                                        @if(request('category') == $category->slug) style="color: #159abe;" @endif>
                                                        {{ $category->name }}
                                                    </a>
                                                    @if($category->hasChildren())
                                                        <ul style="display: block; padding-left: 15px;">
                                                            @foreach($category->children as $child)
                                                <li>
                                                                    <div class="mn-sidebar-sub-item">
                                                                        <a href="javascript:void(0)"
                                                                           data-category="{{ $child->slug }}"
                                                                           class="{{ request('category') == $child->slug ? 'active' : '' }}"
                                                                           @if(request('category') == $child->slug) style="color: #159abe;" @endif>
                                                                            {{ $child->name }}
                                                                        </a>
                                                    </div>
                                                </li>
                                                            @endforeach
                                            </ul>
                                                    @endif
                                        </li>
                                    </ul>
                                </div>
                                @endforeach
                                
                                <!-- Keep the existing Price block -->
                                <div class="mn-sidebar-block mt-3 mb-4">
                                <div class="mn-sb-title">
                                    <h3 class="mn-sidebar-title">Price Range</h3>
                                </div>
                                <div class="mn-sb-block-content">
                                    <ul>
                                        <li class="price-range-item">
                                            <div class="mn-sidebar-block-item">
                                                <input type="radio" name="price_range" value="0-5000" 
                                                    {{ request('price_range') == '0-5000' ? 'checked' : '' }}>
                                                <a href="javascript:void(0)" 
                                                   style="{{ request('price_range') == '0-5000' ? 'color: #159abe;' : '' }}">৳0 - ৳5,000</a>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li class="price-range-item">
                                            <div class="mn-sidebar-block-item">
                                                <input type="radio" name="price_range" value="5000-10000"
                                                    {{ request('price_range') == '5000-10000' ? 'checked' : '' }}>
                                                <a href="javascript:void(0)"
                                                   style="{{ request('price_range') == '5000-10000' ? 'color: #159abe;' : '' }}">৳5,000 - ৳10,000</a>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li class="price-range-item">
                                            <div class="mn-sidebar-block-item">
                                                <input type="radio" name="price_range" value="10000-25000"
                                                    {{ request('price_range') == '10000-25000' ? 'checked' : '' }}>
                                                <a href="javascript:void(0)"
                                                   style="{{ request('price_range') == '10000-25000' ? 'color: #159abe;' : '' }}">৳10,000 - ৳25,000</a>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li class="price-range-item">
                                            <div class="mn-sidebar-block-item">
                                                <input type="radio" name="price_range" value="25000-50000"
                                                    {{ request('price_range') == '25000-50000' ? 'checked' : '' }}>
                                                <a href="javascript:void(0)"
                                                   style="{{ request('price_range') == '25000-50000' ? 'color: #159abe;' : '' }}">৳25,000 - ৳50,000</a>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li class="price-range-item">
                                            <div class="mn-sidebar-block-item">
                                                <input type="radio" name="price_range" value="50000-100000"
                                                    {{ request('price_range') == '50000-100000' ? 'checked' : '' }}>
                                                <a href="javascript:void(0)"
                                                   style="{{ request('price_range') == '50000-100000' ? 'color: #159abe;' : '' }}">৳50,000 - ৳100,000</a>
                                                <span class="checked"></span>
                                        </div>
                                        </li>
                                        <li class="price-range-item">
                                            <div class="mn-sidebar-block-item">
                                                <input type="radio" name="price_range" value="100000-200000"
                                                    {{ request('price_range') == '100000-200000' ? 'checked' : '' }}>
                                                <a href="javascript:void(0)"
                                                   style="{{ request('price_range') == '100000-200000' ? 'color: #159abe;' : '' }}">৳100,000 - ৳200,000</a>
                                                <span class="checked"></span>
                                    </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <!-- Brands Block -->
                            <div class="mn-sidebar-block">
                                <div class="mn-sb-title">
                                    <h3 class="mn-sidebar-title">Brands</h3>
                                </div>
                                <div class="mn-sb-block-content">
                                    <div class="d-flex flex-wrap align-items-center brands-wrap pt-2">
                                        @foreach($brands as $brand)
                                            <a href="{{ request()->fullUrlWithQuery(['brand' => Str::slug($brand->title)]) }}" title="{{ $brand->title }}">
                                                @if($brand->logo)
                                                    <img src="{{ asset('storage/'.$brand->logo) }}" alt="{{ $brand->title }}" class="brand-logo-mini">
                                                @else
                                                    <span class="badge bg-light text-dark" style="font-size:11px">{{ $brand->title }}</span>
                                                @endif
                                            </a>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <!-- Sidebar Color item -->
                            <div class="mn-sidebar-block color-block mn-sidebar-block-clr">
                                <div class="mn-sb-title">
                                    <h3 class="mn-sidebar-title">Color</h3>
                                </div>
                                <div class="mn-sb-block-content">
                                    <ul>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="black">
                                                <span class="mn-clr-block"
                                                    style="background-color:black;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="white">
                                                <span class="mn-clr-block"
                                                    style="background-color:white; border:1px solid #ccc;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="gray">
                                                <span class="mn-clr-block"
                                                    style="background-color:gray;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li class="active">
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="red">
                                                <span class="mn-clr-block"
                                                    style="background-color:red;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="blue">
                                                <span class="mn-clr-block"
                                                    style="background-color:blue;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="green">
                                                <span class="mn-clr-block"
                                                    style="background-color:green;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="yellow">
                                                <span class="mn-clr-block"
                                                    style="background-color:yellow;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="orange">
                                                <span class="mn-clr-block"
                                                    style="background-color:orange;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="brown">
                                                <span class="mn-clr-block"
                                                    style="background-color:brown;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="pink">
                                                <span class="mn-clr-block"
                                                    style="background-color:pink;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="purple">
                                                <span class="mn-clr-block"
                                                    style="background-color:purple;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="magenta">
                                                <span class="mn-clr-block"
                                                    style="background-color:magenta;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="indigo">
                                                <span class="mn-clr-block"
                                                    style="background-color:indigo;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="violet">
                                                <span class="mn-clr-block"
                                                    style="background-color:violet;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>                                        
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="teal">
                                                <span class="mn-clr-block"
                                                    style="background-color:teal;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="mn-sidebar-block-item">
                                                <input type="checkbox" value="lime">
                                                <span class="mn-clr-block"
                                                    style="background-color:lime;"></span>
                                                <span class="checked"></span>
                                            </div>
                                        </li>
                                    </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mn-shop-rightside col-md-12 m-t-991">
                    <!-- Shop Top Start -->
                    <div class="mn-pro-list-top d-flex">
                        <div class="col-md-6 mn-grid-list">
                            <div class="mn-gl-btn">
                                <button class="grid-btn filter-toggle-icon">
                                    <i class="ri-filter-2-line"></i>
                                </button>
                                <button class="grid-btn btn-grid-50 active">
                                    <i class="ri-gallery-view-2"></i>
                                </button>
                                <button class="grid-btn btn-list-50">
                                    <i class="ri-list-check-2"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-6 mn-sort-select">
                            <div class="mn-select-inner">
                                <select name="mn-select" id="mn-select">
                                    <option value="">Default</option>
                                    <option value="latest" {{ request('sort') == 'latest' ? 'selected' : '' }}>Latest</option>
                                    <option value="oldest" {{ request('sort') == 'oldest' ? 'selected' : '' }}>Oldest</option>
                                    <option value="price_low" {{ request('sort') == 'price_low' ? 'selected' : '' }}>Price, low to high</option>
                                    <option value="price_high" {{ request('sort') == 'price_high' ? 'selected' : '' }}>Price, high to low</option>
                                    <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>Name, A to Z</option>
                                    <option value="name_desc" {{ request('sort') == 'name_desc' ? 'selected' : '' }}>Name, Z to A</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <!-- Shop Top End -->

                    <!-- Select Bar Start -->
                    <div class="mn-select-bar d-flex">
                        @if(request('category'))
                            <span class="mn-select-btn">
                                {{ $activeFilters['category'] }}
                                <a class="mn-select-cancel" href="{{ request()->fullUrlWithQuery(['category' => null]) }}">×</a>
                            </span>
                        @endif

                        @if(request('brand'))
                            <span class="mn-select-btn">
                                Brand: {{ $activeFilters['brand'] ?? ucfirst(request('brand')) }}
                                <a class="mn-select-cancel" href="{{ request()->fullUrlWithQuery(['brand' => null]) }}">×</a>
                            </span>
                        @endif

                        @if(request('price_range'))
                            @php
                                [$min, $max] = explode('-', request('price_range'));
                                $priceLabel = '৳' . number_format($min) . ' - ৳' . number_format($max);
                            @endphp
                            <span class="mn-select-btn">
                                {{ $priceLabel }}
                                <a class="mn-select-cancel" href="{{ request()->fullUrlWithQuery(['price_range' => null]) }}">×</a>
                            </span>
                        @endif

                        @if(request('sizes'))
                            <span class="mn-select-btn">
                                Size: {{ str_replace(',', ', ', request('sizes')) }}
                                <a class="mn-select-cancel" href="{{ request()->fullUrlWithQuery(['sizes' => null]) }}">×</a>
                            </span>
                        @endif

                        @if(request('colors'))
                            <span class="mn-select-btn">
                                Color: {{ str_replace(',', ', ', request('colors')) }}
                                <a class="mn-select-cancel" href="{{ request()->fullUrlWithQuery(['colors' => null]) }}">×</a>
                            </span>
                        @endif

                        @if(request('sort'))
                            @php
                                $sortLabels = [
                                    'latest' => 'Latest',
                                    'oldest' => 'Oldest',
                                    'price_low' => 'Price: Low to High',
                                    'price_high' => 'Price: High to Low',
                                    'name_asc' => 'Name: A to Z',
                                    'name_desc' => 'Name: Z to A'
                                ];
                            @endphp
                            <span class="mn-select-btn">
                                {{ $sortLabels[request('sort')] ?? 'Sort' }}
                                <a class="mn-select-cancel" href="{{ request()->fullUrlWithQuery(['sort' => null]) }}">×</a>
                            </span>
                        @endif

                        @if(request()->hasAny(['category', 'brand', 'price_range', 'sizes', 'colors', 'sort']))
                            <span class="mn-select-btn mn-select-btn-clear">
                                <a class="mn-select-clear" href="{{ route('product.list') }}">Clear All</a>
                            </span>
                        @endif
                    </div>
                    <!-- Select Bar End -->

                    <!-- Shop content Start -->
                    <div class="shop-pro-content">
                        <div class="shop-pro-inner">
                            <div class="row">
                                @forelse($products as $product)
                                    <div class="col-lg-3 col-md-4 col-sm-6 col-12 m-b-24 mn-product-box pro-gl-content">
                                        <div class="mn-product-card" 
                                                     data-product-id="{{ $product->id }}"
                                                     data-default-variant-id="{{ $product->variations->where('default', true)->first()->id }}">
                                            <div class="mn-product-img">
                                                <div class="mn-img">
                                                    <a href="{{ route('product.view', ['slug' => $product->slug]) }}" class="image">
                                                        <img class="main-img" 
                                                            src="{{ $product->primary_image->url }}" 
                                                            alt="{{ $product->title }}">
                                                    </a>
                                                    <div class="mn-options mn-options-always-visible">
                                                        <ul>
                                                            <li>
                                                                <a href="javascript:void(0)" 
                                                                   data-tooltip 
                                                                   title="Wishlist" 
                                                                   class="mn-wishlist" 
                                                                   data-product-id="{{ $product->id }}">
                                                                    <i class="ri-heart-line"></i>
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="javascript:void(0)" 
                                                                   data-tooltip 
                                                                   title="Compare" 
                                                                   class="mn-compare" 
                                                                   data-product-id="{{ $product->id }}">
                                                                    <i class="ri-repeat-line"></i>
                                                                </a>
                                                            </li>
                                                            <li>
                                                                @php
                                                                     $defaultInStock = ($product->relationLoaded('variations')
                                                                         ? (int)optional($product->variations->first())->in_stock > 0
                                                                         : (int)($product->variations()->where('default', true)->value('in_stock') ?? 0) > 0);
                                                                     $variantsCount = $product->variants_count ?? $product->variations()->count();
                                                                     $inStockCount = $product->in_stock_variants_count ?? $product->variations()->where('in_stock', '>', 0)->count();
                                                                     $allOut = ($inStockCount === 0);
                                                                     $defaultOut = !$defaultInStock;
                                                                 @endphp
                                                                @if($variantsCount > 1 && $defaultOut && !$allOut)
                                                                    <a href="{{ route('product.view', ['slug' => $product->slug]) }}" data-tooltip title="Open" class="mn-add-cart open-link">
                                                                        <i class="ri-eye-line"></i>
                                                                        Open
                                                                    </a>
                                                                @elseif(($variantsCount === 1 && $defaultOut) || ($variantsCount > 1 && $allOut))
                                                                    <a href="javascript:void(0)" class="mn-add-cart out-stock disabled" style="pointer-events: none; opacity: .85; background: #dc3545; border-color: #dc3545; color: #fff;">
                                                                        <i class="ri-close-line"></i>
                                                                        Out of stock
                                                                    </a>
                                                                @else
                                                                    <a href="javascript:void(0)" data-tooltip title="Add To Cart" class="mn-add-cart">
                                                                        <i class="ri-shopping-cart-line"></i>
                                                                        Add to Cart
                                                                    </a>
                                                                @endif
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mn-product-detail">
                                                    <div class="cat" style="display:flex; align-items:center; justify-content:space-between; gap:10px;">
                                                        <a href="{{ route('product.list', ['category' => $product->category->slug]) }}">
                                                            {{ $product->category->name }}
                                                        </a>
                                                        @if($product->brand)
                                                            <a href="{{ route('product.list', ['brand' => Str::slug($product->brand->title)]) }}">
                                                                {{ $product->brand->title }}
                                                            </a>
                                                        @endif
                                                    </div>
                                                    <h5>
                                                        <a href="{{ route('product.view', ['slug' => $product->slug]) }}">
                                                            {{ $product->title }}
                                                        </a>
                                                    </h5>
                                                @php $avg = $product->average_rating ?? ($product->averageRating ?? 0); @endphp
                                                <div class="mn-card-meta">
                                                    <div class="mn-price" style="margin:0;">
                                                        @php
                                                            $defaultVariation = $product->variations->where('default', true)->first();
                                                        @endphp
                                                        @if($defaultVariation)
                                                            <div class="mn-price-new">৳{{ number_format($defaultVariation->sale_price) }}</div>
                                                            @if($defaultVariation->regular_price > $defaultVariation->sale_price)
                                                                <div class="mn-price-old">৳{{ number_format($defaultVariation->regular_price) }}</div>
                                                            @endif
                                                        @endif
                                                    </div>
                                                    <div class="mn-card-rating">
                                                        @php
                                                            $icon = 'ri-star-line';
                                                            if ($avg >= 0.75) { $icon = 'ri-star-fill'; }
                                                            elseif ($avg >= 0.25) { $icon = 'ri-star-half-s-fill'; }
                                                        @endphp
                                                        <i class="{{ $icon }}"></i>
                                                        <span class="num">{{ number_format($avg,1) }}</span>
                                                    </div>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    @empty
                                        <div class="col-12 text-center py-5">
                                            <h3>No products found</h3>
                                            <p>Try adjusting your filters or search criteria</p>
                                    </div>
                                    @endforelse
                                </div>
                            </div>
                            <!-- Pagination Start -->
                            {{ $products->links('partial.pagination') }}
                            <!-- Pagination End -->
                        </div>
                        <!--Shop content End -->
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section("script")
<script>
// Helper function to update URL while preserving other parameters
function updateUrlWithFilter(paramName, paramValue) {
    const currentUrl = new URL(window.location.href);
    const params = new URLSearchParams(currentUrl.search);
    
    if (paramValue) {
        params.set(paramName, paramValue);
    } else {
        params.delete(paramName);
    }
    
    currentUrl.search = params.toString();
    window.location.href = currentUrl.toString();
}

// Handle category clicks
document.querySelectorAll('[data-category]').forEach(link => {
    link.addEventListener('click', function(e) {
        e.preventDefault();
        updateUrlWithFilter('category', this.dataset.category);
    });
});

// Handle sort change
document.getElementById('mn-select')?.addEventListener('change', function(e) {
    setTimeout(() => {
        updateUrlWithFilter('sort', e.target.value);
    }, 500);
});

// Handle price range radio buttons
document.querySelectorAll('input[name="price_range"]').forEach(radio => {
    radio.addEventListener('change', function() {
        updateUrlWithFilter('price_range', this.value);
    });
});

// Handle size checkboxes
document.querySelectorAll('input[type="checkbox"][value^="S"], input[type="checkbox"][value^="M"], input[type="checkbox"][value^="L"], input[type="checkbox"][value^="XL"]').forEach(checkbox => {
    checkbox.addEventListener('change', function() {
        const currentUrl = new URL(window.location.href);
        const params = new URLSearchParams(currentUrl.search);
        
        // Get all currently selected sizes
        const selectedSizes = Array.from(document.querySelectorAll('input[type="checkbox"]:checked'))
            .filter(cb => ['S', 'M', 'L', 'XL'].includes(cb.value))
            .map(cb => cb.value);
        
        if (selectedSizes.length > 0) {
            params.set('sizes', selectedSizes.join(','));
        } else {
            params.delete('sizes');
        }
        
        currentUrl.search = params.toString();
        window.location.href = currentUrl.toString();
    });
});

// Handle color checkboxes
document.querySelectorAll('.mn-sidebar-block-clr input[type="checkbox"]').forEach(checkbox => {
    checkbox.addEventListener('change', function() {
        const currentUrl = new URL(window.location.href);
        const params = new URLSearchParams(currentUrl.search);
        
        // Get all currently selected colors
        const selectedColors = Array.from(document.querySelectorAll('.mn-sidebar-block-clr input[type="checkbox"]:checked'))
            .map(cb => cb.value);
        
        if (selectedColors.length > 0) {
            params.set('colors', selectedColors.join(','));
        } else {
            params.delete('colors');
        }
        
        currentUrl.search = params.toString();
        window.location.href = currentUrl.toString();
    });
});

// Pre-select filters from URL params
document.addEventListener('DOMContentLoaded', function() {
    const params = new URLSearchParams(window.location.search);
    
    // Set size checkboxes
    if (params.has('sizes')) {
        const sizes = params.get('sizes').split(',');
        sizes.forEach(size => {
            const checkbox = document.querySelector(`input[type="checkbox"][value="${size}"]`);
            if (checkbox) checkbox.checked = true;
        });
    }
    
    // Set color checkboxes
    if (params.has('colors')) {
        const colors = params.get('colors').split(',');
        colors.forEach(color => {
            const checkbox = document.querySelector(`.mn-sidebar-block-clr input[type="checkbox"][value="${color}"]`);
            if (checkbox) checkbox.checked = true;
        });
    }
});
</script>
@endsection