@extends("general_base")
@section("title", "FAQ")
@section("style")
<style>
.mn-faq {
    padding: 50px 0;
}
.mn-faq .mn-title {
    text-align: center;
    margin-bottom: 40px;
}
.mn-faq .mn-title h2 {
    font-size: 32px;
    margin-bottom: 10px;
    text-transform: capitalize;
}
.mn-faq .mn-title h2 span {
    color: var(--primary);
}
</style>
@endsection
@section("content")
<section class="mn-faq p-b-15">
    <div class="mn-title">
        <h2>frequently asked <span>questions</span></h2>
        <p>Find answers to common questions about our services.</p>
    </div>
    <div class="row">
        @php
            $halfCount = ceil($faqs->count() / 2);
            $firstHalf = $faqs->take($halfCount);
            $secondHalf = $faqs->skip($halfCount);
        @endphp
        
        <div class="col-lg-6">
            <div class="mn-accordion style-1">
                @foreach($firstHalf as $faq)
                <div class="mn-accordion-item">
                    <h4 class="mn-accordion-header">
                        {{ $faq->question }}
                    </h4>
                    <div class="mn-accordion-body {{ $loop->first ? 'show' : '' }}">
                        {!! $faq->answer !!}
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        <div class="col-lg-6 m-t-991">
            <div class="mn-accordion style-1">
                @foreach($secondHalf as $faq)
                <div class="mn-accordion-item">
                    <h4 class="mn-accordion-header">
                        {{ $faq->question }}
                    </h4>
                    <div class="mn-accordion-body {{ $loop->first && $firstHalf->isEmpty() ? 'show' : '' }}">
                        {!! $faq->answer !!}
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
@endsection
@section("script")
<script>
// Add any necessary JavaScript for accordion functionality
</script>
@endsection