<div class="mn-comment" data-comment-id="{{ $comment->id }}">
    <div class="mn-comment-header">
        <div class="mn-comment-form-avatar">
            <i class="ri-user-3-line"></i>
        </div>
        <div>
            {{ $comment->user->first_name }} {{ $comment->user->last_name }} <time>· {{ $comment->created_at->diffForHumans() }}</time>
        </div>
    </div>
    <div class="mn-comment-content">
        {{ $comment->comment }}
    </div>
    <div class="mn-comment-actions">
        @auth
            <span class="mn-comment-action" onclick="replyToComment('{{ $comment->id }}')">Reply</span>
            @if(auth()->id() === $comment->user_id)
                <span class="mn-comment-action" onclick="deleteComment('{{ $comment->id }}')">Delete</span>
            @endif
        @endauth
    </div>
    @if($comment->replies && $comment->replies->count() > 0)
        <div class="mn-comment-replies">
            @foreach($comment->replies as $reply)
                @include('blog.partials.reply', ['reply' => $reply])
            @endforeach
        </div>
    @endif
</div>