@extends("general_base")
@section("title", "Login to Continue")
@section("style")
<style>
.mn-login-content {
  max-width: 1000px;
  margin: auto;
  padding: 30px 15px;
  background-color: #fff;
  border-radius: 15px;
  border: 1px solid #e5e5e5;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: horizontal;
  -webkit-box-direction: normal;
      -ms-flex-direction: row;
          flex-direction: row;
}
.mn-login-content .mn-login-box {
  width: 50%;
  padding: 0 15px;
}

.mn-login-wrapper {
  max-width: 530px;
  height: 100%;
  margin: 0 auto 0;
}
.mn-login-wrapper .mn-login-wrap {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: vertical;
  -webkit-box-direction: normal;
      -ms-flex-direction: column;
          flex-direction: column;
}
.mn-login-wrapper .mn-login-fp {
  margin-top: 5px;
  -webkit-box-orient: horizontal;
  -webkit-box-direction: normal;
      -ms-flex-direction: row;
          flex-direction: row;
  -webkit-box-pack: justify;
      -ms-flex-pack: justify;
          justify-content: space-between;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
}
.mn-login-wrapper .mn-login-container {
  height: 100%;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  text-align: left;
}
.mn-login-wrapper .mn-login-container .mn-login-form {
  width: 100%;
}
.mn-login-wrapper .mn-login-container .mn-login-form form {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: vertical;
  -webkit-box-direction: normal;
      -ms-flex-direction: column;
          flex-direction: column;
}
.mn-login-wrapper .mn-login-container .mn-login-form label {
  margin-bottom: 10px;
  color: #313b50;
  font-size: 14px;
  font-weight: 500;
  letter-spacing: 0;
  line-height: 1;
}
.mn-login-wrapper .mn-login-container .mn-login-form input {
  height: 50px;
  margin-bottom: 24px;
  padding: 0 15px;
  background-color: transparent;
  border: 1px solid #e5e5e5;
  border-radius: 15px;
  font-size: 14px;
  outline: none;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-wrap + .mn-login-wrap input {
  margin-bottom: 15px;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-fp label {
  margin-bottom: 0;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-fp label a {
  color: #777;
  font-size: 14px;
  font-weight: 400;
  letter-spacing: 0px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: end;
      -ms-flex-pack: end;
          justify-content: flex-end;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-fp label a:hover {
  color: #159abe;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: vertical;
  -webkit-box-direction: normal;
      -ms-flex-direction: column;
          flex-direction: column;
  -webkit-box-pack: center;
      -ms-flex-pack: center;
          justify-content: center;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn {
  margin-top: 30px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: horizontal;
  -webkit-box-direction: normal;
      -ms-flex-direction: row;
          flex-direction: row;
  -webkit-box-pack: justify;
      -ms-flex-pack: justify;
          justify-content: space-between;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn button {
  padding: 8px 15px;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn button span {
  -webkit-transition: all 0.3s ease-in-out;
  transition: all 0.3s ease-in-out;
  color: #313b50;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn button:hover span {
  color: #fff;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn span {
  color: #777;
  font-size: 14px;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn span a {
  color: #313b50;
  font-weight: 600;
}
.mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn span a:hover {
  color: #159abe;
}

.mn-login-img {
    background-image: url("{{ asset('assets/auth_animate.gif') }}");
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    width: 100%;
    height: 100%;
    border-radius: 15px;
}

.mn-remember {
  position: relative;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  -ms-flex-wrap: wrap;
      flex-wrap: wrap;
  color: #313b50;
  font-weight: 500;
  line-height: 20px;
  font-size: 14px;
  -webkit-user-select: none;
     -moz-user-select: none;
      -ms-user-select: none;
          user-select: none;
}
.mn-remember input {
  width: 18px;
  height: 18px !important;
  margin: 0 10px 0 0 !important;
  position: relative !important;
  opacity: 0;
  border-color: #e5e5e5;
  cursor: pointer;
  z-index: 9;
}
.mn-remember input:checked ~ .checked:after {
  display: block;
}
.mn-remember .checked {
  width: 18px;
  height: 18px;
  position: absolute;
  top: 0;
  left: 0;
  background-color: #fff;
  border: 1px solid #e5e5e5;
  border-radius: 5px;
  -webkit-transition: all 300ms linear;
  transition: all 300ms linear;
}
.mn-remember .checked:after {
  width: 18px;
  height: 18px;
  left: -1px;
  top: 0;
  border: 1px solid #159abe;
  content: "\eb7b";
  position: relative;
  display: none;
  font-family: "remixicon";
  font-size: 15px;
  color: #159abe;
  line-height: 16px;
  text-align: center;
  border-radius: 5px;
}
.btn_social {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background-color: white;
    border: 1px solid #ededed;
    border-radius: 5px;
    padding: 10px 20px;
    text-decoration: none;
    color: #686868;
    font-weight: 500;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    transition: box-shadow 0.3s ease;
}
.btn_social:hover {
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
}
.social_logo {
    width: 20px;
    height: 20px;
    margin-right: 10px;
}
@media only screen and (max-width: 991px) {
  .d-n-991 {
    display: none;
  }
  .mn-login-content {
    max-width: 530px;
    margin: 0 auto 0;
  }
  .mn-login-content .mn-login-box {
    width: 100%;
  }
}
@media only screen and (max-width: 575px) {
  .mn-login-content {
    padding: 15px 0;
  }
  .mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn {
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
        -ms-flex-direction: column;
            flex-direction: column;
  }
  .mn-login-wrapper .mn-login-container .mn-login-form .mn-login-btn > span {
    margin-bottom: 15px;
  }
  .mn-login-wrapper .mn-login-container .mn-login-form .mn-login-fp label a {
    -webkit-box-pack: center;
        -ms-flex-pack: center;
            justify-content: center;
  }
}
@media only screen and (max-width: 320px) {
  .mn-login-wrapper .mn-login-fp {
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
        -ms-flex-direction: column;
            flex-direction: column;
  }
  .mn-login-wrapper .mn-login-fp .mn-remember {
    margin-bottom: 10px;
  }
}
</style>
@endsection
@section("content")
<section class="mn-login p-b-15">
    <div class="mn-login-content">
        <div class="mn-login-box">
            <div class="mn-login-wrapper">
                <div class="mn-login-container">
                    <div class="mn-login-form">
                        <form action="{{ route('login-post') }}" method="POST">
                            @csrf
                            <span class="mn-login-wrap">
                            <label>Email Address</label>
                            <input type="email" name="email" placeholder="example@gmail.com" required>
                            </span>
                            <span class="mn-login-wrap">
                            <label>Password</label>
                            <input type="password" name="password" id="password" placeholder="******" required>
                            </span>
                            <span class="mn-login-wrap mn-login-fp">
                            <span class="mn-remember">
                            <input type="checkbox" name="remember_me" id="remember_me"><label for="remember_me">Remember me</label><span class="checked"></span>
                            </span>
                            <label><a href="{{ route('password.request') }}">Forgot Password?</a></label>
                            </span>
                            <div class="mt-3">
                                {!! NoCaptcha::renderJs() !!}
                                {!! NoCaptcha::display() !!}
                            </div>
                            <span class="mn-login-wrap mn-login-btn">
                            <span>Don't have an account?<a href="{{ route('register') }}"> Create one</a></span>
                            <button type="submit" class="mn-btn-1 btn"><span>Login</span></button>
                            </span>
                        </form>
                        <div class="text-center">
                            <hr class="mx-auto w-25">
                            <a href="{{ route('google_auth') }}" class="btn btn_social mb-2">
                                <img src="{{ asset('assets/google_logo.png') }}" class="social_logo">
                                <span>Continue with Google</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="mn-login-box d-n-991">
            <div class="mn-login-img"></div>
        </div>
    </div>
</section>
@endsection