@extends('admin_base')

@section('title', 'Settings')

@section('style')
<style>
	/* Page: Settings */
	.settings-header { display:flex; align-items:center; gap:12px; }
	.settings-avatar { width:52px; height:52px; border-radius:50%; background:#f3f4f6; display:flex; align-items:center; justify-content:center; color:#159abe; }
	.settings-sub { color:#6b7280; font-size:13px; }
	.nav-settings { background:#fff; border-radius:8px; padding:8px; border:1px solid #e5e7eb; }
	.nav-settings .nav-link { color:#4b5563; border-radius:6px; padding:10px 12px; font-weight:500; }
	.nav-settings .nav-link i { width:18px; text-align:center; margin-right:6px; color:#6b7280; }
	.nav-settings .nav-link.active { background:#f0f4ff; color:#1f2937; }
	.card-settings { border:1px solid #e5e7eb; border-radius:10px; }
	.section-title { font-size:14px; font-weight:600; color:#111827; margin-bottom:10px; display:flex; align-items:center; gap:8px; }
	.helper { font-size:12px; color:#6b7280; }
	.input-hint { font-size:12px; color:#6b7280; margin-top:4px; }
	.http-method { font-weight:600; }
	.http-get { background:#e8f5e9; color:#1b5e20; border-color:#c8e6c9; }
	.preview-box { display:flex; align-items:center; gap:10px; }
	.preview-thumb { height:44px; width:auto; border-radius:6px; border:1px solid #e5e7eb; background:#fafafa; padding:4px; }
	.sticky-save { position:sticky; bottom:0; background:#fff; padding:12px; display:flex; justify-content:flex-end; border-bottom-left-radius:10px; border-bottom-right-radius:10px; }
	.unsaved-pill { display:none; align-items:center; gap:6px; background:#fff3cd; color:#664d03; border:1px solid #ffecb5; padding:6px 10px; border-radius:999px; font-size:12px; margin-right:auto; }
	.form-row.g-10 > [class^="col-"] { padding-left:10px; padding-right:10px; }
	.form-row.g-10 { margin-left:-10px; margin-right:-10px; }
	@media (max-width: 991px) { .nav-settings { margin-bottom:12px; } }
	.logo_placeholder { width: 200px; height: 60px; border: 3px dashed #bbb; display: flex; align-items: center; justify-content: center; background: #fafbfc; }
	.logo_placeholder img { width: 100%; }
	/* Password toggle button */
	.password-toggle { cursor: pointer; padding: 6px 12px; background: none; border: 1px solid #ced4da; border-left: none; }
	.password-toggle:hover { background: #f8f9fa; }
	.password-toggle i { color: #6c757d; }
</style>
@endsection

@section('content')
<div class="row">
	<div class="col-12">
		<div class="card card-settings">
			<div class="card-body pb-2">
				<div class="settings-header mb-3">
					<div class="settings-avatar"><i class="fas fa-sliders-h"></i></div>
					<div>
						<h4 class="mb-0">Site Settings</h4>
						<div class="settings-sub">Manage branding, SEO, environment and integrations</div>
					</div>
				</div>

				@if ($errors->any())
					<div class="alert alert-danger">
						<ul class="mb-0">
							@foreach ($errors->all() as $error)
								<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
				@endif

				<form id="settingsForm" action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data">
					@csrf

					<div class="row">
						<div class="col-lg-3">
							<ul class="nav flex-lg-column nav-pills nav-settings" id="settingsTabs" role="tablist">
								<li class="nav-item" role="presentation">
									<a class="nav-link active" id="tab-branding" data-toggle="pill" href="#pane-branding" role="tab"><i class="fas fa-image"></i>Branding</a>
								</li>
								<li class="nav-item" role="presentation">
									<a class="nav-link" id="tab-seo" data-toggle="pill" href="#pane-seo" role="tab"><i class="fas fa-chart-line"></i>SEO & Analytics</a>
								</li>
								<li class="nav-item" role="presentation">
									<a class="nav-link" id="tab-app" data-toggle="pill" href="#pane-app" role="tab"><i class="fas fa-cog"></i>App</a>
								</li>
								<li class="nav-item" role="presentation">
									<a class="nav-link" id="tab-mail" data-toggle="pill" href="#pane-mail" role="tab"><i class="fas fa-envelope"></i>Mail</a>
								</li>
								<li class="nav-item" role="presentation">
									<a class="nav-link" id="tab-security" data-toggle="pill" href="#pane-security" role="tab"><i class="fas fa-shield-alt"></i>NoCaptcha</a>
								</li>
                                <li class="nav-item" role="presentation">
									<a class="nav-link" id="tab-integrations" data-toggle="pill" href="#pane-integrations" role="tab"><i class="fas fa-plug"></i>Integrations</a>
								</li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" id="tab-payment" data-toggle="pill" href="#pane-payment" role="tab"><i class="fas fa-money-check-alt"></i>Payment</a>
                                </li>
								<li class="nav-item" role="presentation">
									<a class="nav-link" id="tab-contact" data-toggle="pill" href="#pane-contact" role="tab"><i class="fas fa-address-book"></i>Footer Info</a>
								</li>
								<li class="nav-item" role="presentation">
									<a class="nav-link" id="tab-api" data-toggle="pill" href="#pane-api" role="tab"><i class="fas fa-key"></i>API</a>
								</li>
							</ul>
						</div>

						<div class="col-lg-9">
							<div class="tab-content" id="settingsTabContent">
								<!-- Branding -->
								<div class="tab-pane fade show active" id="pane-branding" role="tabpanel">
									<div class="section-title"><i class="fas fa-image"></i>Branding</div>
									<div class="form-group">
										<label>Site Logo <span class="helper">(recommended PNG/SVG, max 2MB)</span></label>
										<div class="preview-box">
											<input type="file" name="site_logo" class="form-control-file" accept="image/*" id="siteLogoInput">
											@if($settings->site_logo_path)
												<img src="{{ Storage::url($settings->site_logo_path) }}" class="preview-thumb" id="siteLogoPreview">
											@else
												<div class="logo_placeholder">
													<img src="{{ asset('assets/default_img.png') }}" class="preview-thumb" id="siteLogoPreview">
												</div>
											@endif
										</div>
										<div class="input-hint">Tip: Keep transparent background for best result.</div>
									</div>
									<div class="form-group">
									<label>Admin Logo <span class="helper">(PNG/SVG)</span></label>
									<div class="preview-box">
										<input type="file" name="admin_logo" class="form-control-file" accept="image/*" id="adminLogoInput">
										@if($settings->admin_logo_path)
											<img src="{{ Storage::url($settings->admin_logo_path) }}" class="preview-thumb" id="adminLogoPreview">
										@else
											<div class="logo_placeholder">
												<img src="{{ asset('assets/default_img.png') }}" class="preview-thumb" id="adminLogoPreview">
											</div>
										@endif
									</div>
								</div>
									<div class="form-group">
										<label>Favicon <span class="helper" title="Shown in browser tab">(recommended ICO/PNG, max 1MB)</span></label>
										<div class="preview-box">
											<input type="file" name="favicon" class="form-control-file" accept="image/*" id="faviconInput">
											@if($settings->favicon_path)
												<img src="{{ Storage::url($settings->favicon_path) }}" class="preview-thumb" id="faviconPreview">
											@else
												<div class="logo_placeholder">
													<img src="{{ asset('assets/default_img.png') }}" class="preview-thumb" id="faviconPreview">
												</div>
											@endif
										</div>
										<div class="input-hint">Tip: Use a square image for best results.</div>
									</div>
									<div class="form-group mb-3">
										<label>Footer Copyright</label>
										<input type="text" name="footer_copyright" value="{{ old('footer_copyright', $settings->footer_copyright) }}" class="form-control" placeholder="© {{ date('Y') }} {{ config('app.name') }} | All Rights Reserved.">
									</div>
									<div class="form-group">
										<label>Loader Image <span class="helper">(used in site preloader)</span></label>
										<div class="preview-box">
											<input type="file" name="loader_image" class="form-control-file" accept="image/*" id="loaderImageInput">
											@if($settings->loader_image_path)
												<img src="{{ Storage::url($settings->loader_image_path) }}" class="preview-thumb" id="loaderImagePreview">
											@else
												<div class="logo_placeholder">
													<img src="{{ asset('assets/default_img.png') }}" class="preview-thumb" id="loaderImagePreview">
												</div>
											@endif
										</div>
									</div>
								</div>

								<!-- SEO -->
								<div class="tab-pane fade" id="pane-seo" role="tabpanel">
									<div class="section-title"><i class="fas fa-search"></i>SEO & Analytics</div>
									<div class="form-row g-10">
										<div class="form-group col-md-12">
											<label>Google Analytics ID</label>
											<input type="text" name="google_analytics_id" value="{{ old('google_analytics_id', $settings->google_analytics_id) }}" class="form-control" placeholder="G-XXXXXXXXXX">
											<div class="input-hint">Use GA4 ID like G-XXXXXXXXXX</div>
										</div>
										<div class="form-group col-md-12">
											<label>Meta Keywords</label>
											<textarea name="meta_keywords" class="form-control" rows="2" placeholder="keyword1, keyword2">{{ old('meta_keywords', $settings->meta_keywords) }}</textarea>
										</div>
										<div class="form-group col-md-12 mb-0">
											<label>Meta Description</label>
											<textarea name="meta_description" class="form-control" rows="3" placeholder="Short description for SEO.">{{ old('meta_description', $settings->meta_description) }}</textarea>
										</div>
									</div>
								</div>

								<!-- App -->
								<div class="tab-pane fade" id="pane-app" role="tabpanel">
									<div class="section-title"><i class="fas fa-cog"></i>App</div>
									<div class="form-row g-10">
										<div class="form-group col-md-6">
											<label>Site Name</label>
											<input type="text" name="APP_NAME" value="{{ $env['APP_NAME'] }}" class="form-control" placeholder="{{ config('app.name') }}">
										</div>
										<div class="form-group col-md-6">
											<label>App URL</label>
											<input type="text" name="APP_URL" value="{{ $env['APP_URL'] }}" class="form-control" placeholder="https://example.com">
										</div>
									</div>
								</div>

                                <!-- Payment (SSLCommerz) -->
                                <div class="tab-pane fade" id="pane-payment" role="tabpanel">
                                    <div class="section-title"><i class="fas fa-money-check-alt"></i>Payment (SSLCommerz)</div>
                                    <div class="form-row g-10">
                                        <div class="form-group col-md-6">
                                            <label>Store ID</label>
                                            <input type="text" class="form-control" name="SSLCZ_STORE_ID" value="{{ $env['SSLCZ_STORE_ID'] }}" placeholder="Your SSLCommerz Store ID">
                                        </div>
                                        <div class="form-group col-md-6">
                                            <label>Store Password</label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" name="SSLCZ_STORE_PASSWORD" value="{{ $env['SSLCZ_STORE_PASSWORD'] }}" placeholder="Your SSLCommerz Store Password">
                                                <button type="button" class="password-toggle" onclick="togglePassword(this)"><i class="fas fa-eye"></i></button>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6 mb-0">
                                            <label>Sandbox Mode</label>
                                            <select name="SSLCZ_SANDBOX" class="form-control">
                                                <option value="1" {{ $env['SSLCZ_SANDBOX'] ? 'selected' : '' }}>Enabled (Test)</option>
                                                <option value="0" {{ $env['SSLCZ_SANDBOX'] ? '' : 'selected' }}>Disabled (Live)</option>
                                            </select>
                                            <small class="form-text text-muted">Use sandbox for testing; switch to live for production.</small>
                                        </div>
                                    </div>
                                </div>

								<!-- Mail -->
								<div class="tab-pane fade" id="pane-mail" role="tabpanel">
									<div class="section-title"><i class="fas fa-envelope"></i>Mail</div>
									<div class="form-row g-10">
										<div class="form-group col-sm-4"><label>Mailer</label><input type="text" name="MAIL_MAILER" class="form-control" value="{{ $env['MAIL_MAILER'] }}" placeholder="smtp"></div>
										<div class="form-group col-sm-4"><label>Host</label><input type="text" name="MAIL_HOST" class="form-control" value="{{ $env['MAIL_HOST'] }}" placeholder="smtp.mailtrap.io"></div>
										<div class="form-group col-sm-4"><label>Port</label><input type="text" name="MAIL_PORT" class="form-control" value="{{ $env['MAIL_PORT'] }}" placeholder="587"></div>
										<div class="form-group col-sm-6"><label>Username</label><input type="text" name="MAIL_USERNAME" class="form-control" value="{{ $env['MAIL_USERNAME'] }}"></div>
										<div class="form-group col-sm-6">
											<label>Password</label>
											<div class="input-group">
												<input type="password" name="MAIL_PASSWORD" class="form-control" value="{{ $env['MAIL_PASSWORD'] }}">
												<button type="button" class="password-toggle" onclick="togglePassword(this)">
													<i class="fas fa-eye"></i>
												</button>
											</div>
										</div>
										<div class="form-group col-sm-6"><label>Encryption</label><input type="text" name="MAIL_ENCRYPTION" class="form-control" value="{{ $env['MAIL_ENCRYPTION'] }}" placeholder="tls"></div>
										<div class="form-group col-sm-6"><label>From Address</label><input type="text" name="MAIL_FROM_ADDRESS" class="form-control" value="{{ $env['MAIL_FROM_ADDRESS'] }}"></div>
										<div class="form-group col-sm-6"><label>From Name</label><input type="text" name="MAIL_FROM_NAME" class="form-control" value="{{ $env['MAIL_FROM_NAME'] }}"></div>
										<div class="form-group col-sm-6 mb-0">
											<label>Notify Admin</label>
											<input type="text" name="ADMIN_NOTIFIER_MAIL" class="form-control" value="{{ $env['ADMIN_NOTIFIER_MAIL'] }}">
											<small class="form-text text-muted">All mail notifications about the platform will be sent to this email address.</small>
										</div>
									</div>
								</div>

								<!-- Security / NoCaptcha -->
								<div class="tab-pane fade" id="pane-security" role="tabpanel">
									<div class="section-title"><i class="fas fa-shield-alt"></i>NoCaptcha <i class="fas fa-info-circle text-muted" data-toggle="tooltip" data-placement="top" title="Google reCAPTCHA v2 Checkbox"></i></div>
									<div class="form-row g-10">
										<div class="form-group col-md-6"><label>Site Key</label><input type="text" class="form-control" name="NOCAPTCHA_SITEKEY" value="{{ $env['NOCAPTCHA_SITEKEY'] }}"></div>
										<div class="form-group col-md-6 mb-0">
											<label>Secret</label>
											<div class="input-group">
												<input type="password" name="NOCAPTCHA_SECRET" class="form-control" value="{{ $env['NOCAPTCHA_SECRET'] }}">
												<button type="button" class="password-toggle" onclick="togglePassword(this)">
													<i class="fas fa-eye"></i>
												</button>
											</div>
										</div>
									</div>
								</div>

                                <!-- Integrations -->
																	<div class="tab-pane fade" id="pane-integrations" role="tabpanel">
										<div class="section-title"><i class="fas fa-plug"></i>Integrations</div>
										<div class="form-row g-10">
											<div class="form-group col-md-6"><label>Google Client ID</label><input type="text" class="form-control" name="GOOGLE_CLIENT_ID" value="{{ $env['GOOGLE_CLIENT_ID'] }}"></div>
											<div class="form-group col-md-6">
												<label>Google Client Secret</label>
												<div class="input-group">
													<input type="password" name="GOOGLE_CLIENT_SECRET" class="form-control" value="{{ $env['GOOGLE_CLIENT_SECRET'] }}">
													<button type="button" class="password-toggle" onclick="togglePassword(this)">
														<i class="fas fa-eye"></i>
													</button>
												</div>

                                
											</div>
											<div class="form-group col-md-12"><label>Google Redirect URI</label><input type="text" class="form-control" name="GOOGLE_REDIRECT_URI" value="{{ $env['GOOGLE_REDIRECT_URI'] }}"></div>
											<div class="form-group col-md-12"><label>Tawk.to Key <small class="text-muted">(keep blank if not used)</small></label><input type="text" class="form-control" name="TAWK_KEY" value="{{ $env['TAWK_KEY'] ?? '' }}" placeholder="e.g. 5XXXXXXXX/XXXXXXXXXX"></div>
											<div class="form-group col-md-12 mb-0">
												<label>Facebook Pixel Setup Code</label>
												<textarea class="form-control" name="pixel_code" rows="4" placeholder="Paste your pixel snippet here (it will be injected in <head>)">{{ old('pixel_code', $settings->pixel_code) }}</textarea>
											</div>
										</div>
									</div>

								<!-- Contact -->
								<div class="tab-pane fade" id="pane-contact" role="tabpanel">
									<div class="section-title"><i class="fas fa-address-book"></i>Contact Information</div>
									<div class="form-row g-10">
										<div class="form-group col-md-12">
											<label>Address</label>
											<input type="text" name="contact_address" value="{{ old('contact_address', $settings->contact_address) }}" class="form-control" placeholder="1234 unknown street, mirpur 1216, Dhaka">
										</div>
										<div class="form-group col-md-6">
											<label>Phone Number</label>
											<input type="text" name="contact_phone" value="{{ old('contact_phone', $settings->contact_phone) }}" class="form-control" placeholder="+88 0123456789">
										</div>
										<div class="form-group col-md-6">
											<label>Email Address</label>
											<input type="email" name="contact_email" value="{{ old('contact_email', $settings->contact_email) }}" class="form-control" placeholder="shokherbazar@mail.com">
										</div>
									</div>
									
									<div class="section-title mt-4"><i class="fas fa-share-alt"></i>Social Media Links</div>
									<div id="social-media-wrapper">
										@php $socialMedia = $settings->social_media ?? []; @endphp
										@forelse($socialMedia as $idx => $social)
											<div class="social-media-item" data-index="{{ $idx }}">
												<div class="form-row g-10">
													<div class="form-group col-md-4">
														<label>Platform</label>
														<select name="social_media[{{ $idx }}][platform]" class="form-control">
															<option value="">Select Platform</option>
															<option value="ri-facebook-fill" {{ $social['platform'] == 'ri-facebook-fill' ? 'selected' : '' }}>Facebook</option>
															<option value="ri-twitter-fill" {{ $social['platform'] == 'ri-twitter-fill' ? 'selected' : '' }}>Twitter</option>
															<option value="ri-linkedin-fill" {{ $social['platform'] == 'ri-linkedin-fill' ? 'selected' : '' }}>LinkedIn</option>
															<option value="ri-instagram-line" {{ $social['platform'] == 'ri-instagram-line' ? 'selected' : '' }}>Instagram</option>
															<option value="ri-youtube-fill" {{ $social['platform'] == 'ri-youtube-fill' ? 'selected' : '' }}>YouTube</option>
															<option value="ri-tiktok-fill" {{ $social['platform'] == 'ri-tiktok-fill' ? 'selected' : '' }}>TikTok</option>
															<option value="ri-telegram-fill" {{ $social['platform'] == 'ri-telegram-fill' ? 'selected' : '' }}>Telegram</option>
															<option value="ri-whatsapp-line" {{ $social['platform'] == 'ri-whatsapp-line' ? 'selected' : '' }}>WhatsApp</option>
															<option value="ri-discord-fill" {{ $social['platform'] == 'ri-discord-fill' ? 'selected' : '' }}>Discord</option>
															<option value="ri-reddit-fill" {{ $social['platform'] == 'ri-reddit-fill' ? 'selected' : '' }}>Reddit</option>
															<option value="ri-pinterest-fill" {{ $social['platform'] == 'ri-pinterest-fill' ? 'selected' : '' }}>Pinterest</option>
															<option value="ri-snapchat-fill" {{ $social['platform'] == 'ri-snapchat-fill' ? 'selected' : '' }}>Snapchat</option>
														</select>
													</div>
													<div class="form-group col-md-6">
														<label>URL</label>
														<input type="url" name="social_media[{{ $idx }}][url]" value="{{ $social['url'] ?? '' }}" class="form-control" placeholder="https://...">
													</div>
													<div class="form-group col-md-2">
														<label>&nbsp;</label>
														<button type="button" class="btn btn-danger btn-sm w-100" onclick="removeSocialMedia(this)">
															<i class="fas fa-trash"></i>
														</button>
													</div>
												</div>
											</div>
										@empty
										@endforelse
									</div>
									<button type="button" class="btn btn-secondary btn-sm" onclick="addSocialMedia()">
										<i class="fas fa-plus"></i> Add Social Media
									</button>

									<div class="section-title mt-4"><i class="fas fa-info-circle"></i>Footer Description</div>
									<div class="form-group">
										<label>Footer Description</label>
										<textarea name="footer_description" class="form-control" rows="3">{{ old('footer_description', $settings->footer_description) }}</textarea>
									</div>
								</div>

								<!-- API -->
								<div class="tab-pane fade" id="pane-api" role="tabpanel">
									<div class="section-title"><i class="fas fa-key"></i>API Access</div>
									<div class="form-row g-10">
										<div class="form-group col-md-12">
									<div class="custom-control custom-switch">
										<input type="hidden" name="api_enabled" value="0">
										<input type="checkbox" class="custom-control-input" id="api_enabled" name="api_enabled" value="1" {{ $settings->api_enabled ? 'checked' : '' }}>
										<label class="custom-control-label" for="api_enabled">{{ $settings->api_enabled ? 'API Enabled' : 'API Disabled' }}</label>
											</div>
											<small class="form-text text-muted">If disabled, all API requests will be blocked.</small>
										</div>

										<div class="form-group col-md-12">
											<label>API Key</label>
											<div class="input-group">
												<input type="text" class="form-control" readonly value="{{ $settings->api_key ?? 'Not generated yet' }}">
												<div class="input-group-append">
													<button type="submit" name="regenerate_api_key" value="1" class="btn btn-outline-secondary" onclick="return confirm('Regenerate API key? Existing clients must update.');"><i class="fas fa-sync"></i> Regenerate</button>
												</div>
											</div>
											<div class="input-hint">To access the API, add your API key to the request URL as a query parameter: <code>?api_key={{ $settings->api_key ?? '' }}</code></div>
										</div>

								<div class="form-group col-md-12">
									<label>API URLs</label>
									@php $baseApi = rtrim(config('app.url'), '/') . '/api'; @endphp
									<div class="input-hint">List products (all):</div>
									<div class="input-group mb-2">
										<div class="input-group-prepend">
											<span class="input-group-text http-method http-get">GET</span>
										</div>
										<input type="text" class="form-control" readonly value="{{ $baseApi }}/products/all">
									</div>
									<div class="input-hint mb-2">Returns all products with selected data toggles.</div>
									<!-- slug URL removed per requirement -->
									<div class="input-hint">Single product (by exact title):</div>
									<div class="input-group mb-2">
										<div class="input-group-prepend">
											<span class="input-group-text http-method http-get">GET</span>
										</div>
										<input type="text" class="form-control" readonly value="{{ $baseApi }}/products/title/{title}">
									</div>
									<div class="input-hint mb-2">Fetch a single product by its exact title (URL-encoded). Example: <code>{{ $baseApi }}/products/title/Lenovo Legion 5</code></div>
									<div class="input-hint">Latest N products (limit):</div>
									<div class="input-group">
										<div class="input-group-prepend">
											<span class="input-group-text http-method http-get">GET</span>
										</div>
										<input type="text" class="form-control" readonly value="{{ $baseApi }}/products/limit/{limit}">
									</div>
									<div class="input-hint">Get the most recent N products (newest first). Example: <code>{{ $baseApi }}/products/limit/10</code></div>
								</div>

										<div class="form-group col-md-12">
											<label>Data Toggles</label>
											@php $toggles = $settings->api_data_toggles ?? []; @endphp
											<div class="row">
												<div class="col-md-4">
													<div class="custom-control custom-checkbox">
														<input type="hidden" name="api_data_toggles[products]" value="0">
														<input type="checkbox" class="custom-control-input" id="toggle_products" name="api_data_toggles[products]" value="1" {{ ($toggles['products'] ?? true) ? 'checked' : '' }}>
														<label class="custom-control-label" for="toggle_products">Products</label>
													</div>
												</div>
												<div class="col-md-4">
													<div class="custom-control custom-checkbox">
														<input type="hidden" name="api_data_toggles[category]" value="0">
														<input type="checkbox" class="custom-control-input" id="toggle_category" name="api_data_toggles[category]" value="1" {{ ($toggles['category'] ?? true) ? 'checked' : '' }}>
														<label class="custom-control-label" for="toggle_category">Category</label>
													</div>
												</div>
												<div class="col-md-4">
													<div class="custom-control custom-checkbox">
														<input type="hidden" name="api_data_toggles[brand]" value="0">
														<input type="checkbox" class="custom-control-input" id="toggle_brand" name="api_data_toggles[brand]" value="1" {{ ($toggles['brand'] ?? true) ? 'checked' : '' }}>
														<label class="custom-control-label" for="toggle_brand">Brand</label>
													</div>
												</div>
												<div class="col-md-4">
													<div class="custom-control custom-checkbox">
														<input type="hidden" name="api_data_toggles[images]" value="0">
														<input type="checkbox" class="custom-control-input" id="toggle_images" name="api_data_toggles[images]" value="1" {{ ($toggles['images'] ?? true) ? 'checked' : '' }}>
														<label class="custom-control-label" for="toggle_images">Images</label>
													</div>
												</div>
												<div class="col-md-4">
													<div class="custom-control custom-checkbox">
														<input type="hidden" name="api_data_toggles[stocks]" value="0">
														<input type="checkbox" class="custom-control-input" id="toggle_stocks" name="api_data_toggles[stocks]" value="1" {{ ($toggles['stocks'] ?? true) ? 'checked' : '' }}>
														<label class="custom-control-label" for="toggle_stocks">Stocks</label>
													</div>
												</div>
												<div class="col-md-4">
													<div class="custom-control custom-checkbox">
														<input type="hidden" name="api_data_toggles[ratings]" value="0">
														<input type="checkbox" class="custom-control-input" id="toggle_ratings" name="api_data_toggles[ratings]" value="1" {{ ($toggles['ratings'] ?? true) ? 'checked' : '' }}>
														<label class="custom-control-label" for="toggle_ratings">Ratings</label>
													</div>
												</div>
											</div>
											<div class="input-hint">Only selected data will be included in API responses.</div>
										</div>
									</div>
							</div>

							<div class="sticky-save">
								<div class="unsaved-pill" id="unsavedPill"><i class="fas fa-info-circle"></i> Unsaved changes</div>
								<button type="submit" class="sb_btn"><i class="fas fa-save"></i> Save Changes</button>
							</div>
						</div>
					</div>
				</form>

			</div>
		</div>
	</div>
</div>
@endsection

@section('script')
<script>
(function() {
	function bindPreview(inputId, imgId) {
		var input = document.getElementById(inputId);
		var img = document.getElementById(imgId);
		if (!input || !img) return;
		input.addEventListener('change', function(e) {
			if (this.files && this.files[0]) {
				var reader = new FileReader();
				reader.onload = function(ev) { img.src = ev.target.result; };
				reader.readAsDataURL(this.files[0]);
			}
		});
	}
	bindPreview('siteLogoInput', 'siteLogoPreview');
	bindPreview('adminLogoInput', 'adminLogoPreview');
	bindPreview('faviconInput', 'faviconPreview');
	bindPreview('loaderImageInput', 'loaderImagePreview');

	// Social media functions
	window.socialMediaIndex = {{ count($settings->social_media ?? []) }};

	// Global social media functions
	window.addSocialMedia = function() {
		var wrapper = document.getElementById('social-media-wrapper');
		var newItem = document.createElement('div');
		newItem.className = 'social-media-item';
		newItem.setAttribute('data-index', window.socialMediaIndex);
		
		newItem.innerHTML = `
			<div class="form-row g-10">
				<div class="form-group col-md-4">
					<label>Platform</label>
					<select name="social_media[${window.socialMediaIndex}][platform]" class="form-control">
						<option value="">Select Platform</option>
						<option value="ri-facebook-fill">Facebook</option>
						<option value="ri-twitter-fill">Twitter</option>
						<option value="ri-linkedin-fill">LinkedIn</option>
						<option value="ri-instagram-line">Instagram</option>
						<option value="ri-youtube-fill">YouTube</option>
						<option value="ri-tiktok-fill">TikTok</option>
						<option value="ri-telegram-fill">Telegram</option>
						<option value="ri-whatsapp-line">WhatsApp</option>
						<option value="ri-discord-fill">Discord</option>
						<option value="ri-reddit-fill">Reddit</option>
						<option value="ri-pinterest-fill">Pinterest</option>
						<option value="ri-snapchat-fill">Snapchat</option>
					</select>
				</div>
				<div class="form-group col-md-6">
					<label>URL</label>
					<input type="url" name="social_media[${window.socialMediaIndex}][url]" class="form-control" placeholder="https://...">
				</div>
				<div class="form-group col-md-2">
					<label>&nbsp;</label>
					<button type="button" class="btn btn-danger btn-sm w-100" onclick="removeSocialMedia(this)">
						<i class="fas fa-trash"></i>
					</button>
				</div>
			</div>
		`;
		
		wrapper.appendChild(newItem);
		window.socialMediaIndex++;
	}

	window.removeSocialMedia = function(button) {
		button.closest('.social-media-item').remove();
	}

	// Unsaved changes indicator

	// Unsaved changes indicator
	var form = document.getElementById('settingsForm');
	var pill = document.getElementById('unsavedPill');
	if (form && pill) {
		var initial = new FormData(form);
		var dirty = false;
		form.addEventListener('input', markDirty, true);
		form.addEventListener('change', markDirty, true);
		function markDirty() {
			if (dirty) return;
			dirty = true;
			pill.style.display = 'inline-flex';
		}
		form.addEventListener('submit', function(){ pill.style.display = 'none'; dirty = false; });
	}

	// Persist last tab
	var tabs = $('#settingsTabs a[data-toggle="pill"]');
	tabs.on('shown.bs.tab', function (e) {
		localStorage.setItem('sb_settings_active_tab', $(e.target).attr('href'));
	});
	var last = localStorage.getItem('sb_settings_active_tab');
	if (last) {
		$('#settingsTabs a[href="' + last + '"]').tab('show');
	}
})();

// Password toggle function
function togglePassword(button) {
    const input = button.parentElement.querySelector('input');
    const icon = button.querySelector('i');
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}
</script>
@endsection 