@extends('admin_base')
@section('title', 'Product Reviews')
@section('content')
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Product Reviews</h1>
      </div>
      <div class="col-sm-6 mt-md-0 mt-3">
        <form method="GET" class="float-sm-right" style="max-width: 480px;">
          <div class="input-group">
            <input type="text" name="search" value="{{ request('search') }}" class="form-control" placeholder="Search product or user">
            <div class="input-group-append">
              <button class="btn sb_btn" type="submit"><i class="fas fa-search"></i> Search</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<section class="content">
  <div class="container-fluid">
    <div class="card">
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-striped table-hover mb-0">
            <thead class="bg_sb_primary">
              <tr>
                <th width="60">#</th>
                <th>Product</th>
                <th>User</th>
                <th class="text-center" width="150">Rating</th>
                <th>Comment</th>
                <th width="180">Date</th>
                <th width="80" class="text-center">Action</th>
              </tr>
            </thead>
            <tbody>
              @forelse($ratings as $rating)
              <tr>
                <td>{{ $rating->id }}</td>
                <td>
                  <a href="{{ route('product.view', $rating->product->slug) }}" target="_blank" class="text-primary">
                    {{ $rating->product->title }}
                  </a>
                </td>
                <td>
                  @if($rating->user)
                    <a href="{{ route('admin.users.edit', $rating->user->id) }}" class="text-primary">
                      {{ $rating->user->name }}
                    </a>
                    <br/>
                    <small class="text-muted">{{ $rating->user->email }}</small>
                  @else
                    <span class="text-muted">User</span>
                  @endif
                </td>
                <td class="text-center">
                  <div class="mn-pro-rating" style="font-size: 16px; color:#f5c518;">
                    @for($i=1;$i<=5;$i++)
                      @if($i <= $rating->rating)
                        <i class="fas fa-star"></i>
                      @else
                        <i class="far fa-star"></i>
                      @endif
                    @endfor
                  </div>
                </td>
                <td>{{ $rating->comment }}</td>
                <td><small>{{ $rating->created_at->format('d M Y, h:i A') }}</small></td>
                <td class="text-center">
                  <form action="{{ route('admin.products.reviews.delete', $rating->id) }}" method="POST" onsubmit="return confirm('Delete this review?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-sm btn-danger" title="Delete Review">
                      <i class="fas fa-minus-circle"></i>
                    </button>
                  </form>
                </td>
              </tr>
              @empty
              <tr>
                <td colspan="7" class="text-center py-4">
                  <div class="text-muted">
                    <i class="fas fa-info-circle mr-1"></i> No reviews found
                  </div>
                </td>
              </tr>
              @endforelse
            </tbody>
          </table>
        </div>
        @if($ratings->hasPages())
        <div class="card-footer bg-white">
          <div class="d-flex justify-content-between align-items-center">
            <div class="showing-text">
              Showing {{ $ratings->firstItem() }} to {{ $ratings->lastItem() }} of {{ $ratings->total() }} reviews
            </div>
            {{ $ratings->onEachSide(1)->links('pagination::bootstrap-4') }}
          </div>
        </div>
        @endif
      </div>
    </div>
  </div>
</section>
@endsection 