@extends('admin_base')
@section('title', 'Payments')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center w-100">
                    <h3 class="card-title">Payment History</h3>
                    <div>
                        <a href="{{ route('admin.payments', ['status' => null]) }}" class="btn btn-sm {{ $currentStatus === null ? 'sb_btn' : 'btn-outline-secondary' }}">All</a>
                        <a href="{{ route('admin.payments', ['status' => 'paid']) }}" class="btn btn-sm {{ $currentStatus === 'paid' ? 'sb_btn' : 'btn-outline-secondary' }}">Paid</a>
                        <a href="{{ route('admin.payments', ['status' => 'unpaid']) }}" class="btn btn-sm {{ $currentStatus === 'unpaid' ? 'sb_btn' : 'btn-outline-secondary' }}">Unpaid</a>
                        <a href="{{ route('admin.payments', ['status' => 'failed']) }}" class="btn btn-sm {{ $currentStatus === 'failed' ? 'sb_btn' : 'btn-outline-secondary' }}">Failed</a>
                        <a href="{{ route('admin.payments', ['status' => 'cancelled']) }}" class="btn btn-sm {{ $currentStatus === 'cancelled' ? 'sb_btn' : 'btn-outline-secondary' }}">Cancelled</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Customer</th>
                                <th>Total</th>
                                <th>Method</th>
                                <th>Status</th>
                                <th>TrxID</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($payments as $order)
                            <tr>
                                <td><a href="{{ route('admin.orders.show', $order) }}" class="text-primary">{{ $order->order_number }}</a></td>
                                <td>{{ $order->contact_name }}</td>
                                <td>৳{{ number_format($order->total) }}</td>
                                <td><span class="badge bg-info">SSLCommerz</span></td>
                                <td>
                                    <span class="badge bg-{{ $order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : ($order->payment_status === 'cancelled' ? 'secondary' : 'warning')) }}">
                                        {{ ucfirst($order->payment_status ?? 'unpaid') }}
                                    </span>
                                </td>
                                <td class="font-monospace">{{ $order->payment_trxid ?? '-' }}</td>
                                <td>{{ $order->created_at->format('d M, Y h:i A') }}</td>
                                <td>
                                    <a href="{{ route('admin.orders.show', $order) }}" class="btn btn-sm btn-secondary">View</a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center">No payments found</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-3 d-flex justify-content-end">
                    {{ $payments->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 