<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('api_key')->nullable()->after('footer_description');
            $table->json('api_data_toggles')->nullable()->after('api_key');
            $table->boolean('api_enabled')->default(true)->after('api_data_toggles');
        });
    }

    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            if (Schema::hasColumn('settings', 'api_enabled')) {
                $table->dropColumn('api_enabled');
            }
            if (Schema::hasColumn('settings', 'api_data_toggles')) {
                $table->dropColumn('api_data_toggles');
            }
            if (Schema::hasColumn('settings', 'api_key')) {
                $table->dropColumn('api_key');
            }
        });
    }
};





