<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_number')->unique(); // SB12345
            $table->foreignId('user_id')->constrained()->onDelete('restrict');
            
            // Shipping Information
            $table->string('contact_name');
            $table->string('contact_phone');
            $table->string('whatsapp')->nullable();
            $table->string('contact_email')->nullable();
            $table->text('address');
            $table->string('city');
            $table->string('state');
            $table->string('postal_code');
            
            // Order Totals
            $table->unsignedInteger('subtotal');
            $table->unsignedInteger('delivery_charge');
            $table->unsignedInteger('discount')->default(0);
            $table->unsignedInteger('total');
            
            // Coupon Information (if applied)
            $table->string('coupon_code')->nullable();
            $table->string('coupon_type')->nullable(); // percentage/fixed
            $table->unsignedInteger('coupon_value')->nullable();
            
            // Payment & Status
            $table->string('payment_method')->default('cod');
            $table->string('order_status')->default('pending');
            
            $table->timestamps();
            $table->softDeletes(); // For order archiving
        });
    }

    public function down()
    {
        Schema::dropIfExists('orders');
    }
};
