<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductVariation extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'product_id',
        'unit_type',
        'unit_value',
        'in_stock',
        'sale_price',
        'regular_price',
        'default'
    ];

    protected $casts = [
        'default' => 'boolean'
    ];

    const LOW_STOCK_THRESHOLD = 10;
    const CRITICAL_STOCK_THRESHOLD = 5;

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function is_low_stock(): bool
    {
        return $this->in_stock > self::CRITICAL_STOCK_THRESHOLD && $this->in_stock <= self::LOW_STOCK_THRESHOLD;
    }

    public function is_critical_stock(): bool
    {
        return $this->in_stock > 0 && $this->in_stock <= self::CRITICAL_STOCK_THRESHOLD;
    }

    public function is_out_of_stock(): bool
    {
        return $this->in_stock <= 0;
    }

    public function stock_status(): string
    {
        if ($this->is_out_of_stock()) {
            return 'Out of Stock';
        }
        if ($this->is_critical_stock()) {
            return 'Critical Stock';
        }
        if ($this->is_low_stock()) {
            return 'Low Stock';
        }
        return 'In Stock';
    }
} 