<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;

class Category extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'icon',
        'parent_id'
    ];

    public $timestamps = false;

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($cg) {
            $slug = Str::lower(Str::slug($cg->name));
            $cg->slug = $slug;
        });
    }
    
    public function parent(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function products(): HasMany
    {
        return $this->hasMany(Product::class);
    }

    public function getFullPathAttribute(): string
    {
        $path = collect([$this->name]);
        $category = $this;
        
        while ($category->parent) {
            $path->push($category->parent->name);
            $category = $category->parent;
        }

        return $path->reverse()->join(' > ');
    }

    public function hasChildren(): bool
    {
        return $this->children()->exists();
    }
}