<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BlogReaction extends Model
{
    protected $fillable = [
        'blog_id',
        'user_id',
        'reaction_type'
    ];

    public $timestamps = false;
    
    const REACTIONS = [
        'like' => ['emoji' => '👍', 'color' => '#0d6efd'],
        'love' => ['emoji' => '❤️', 'color' => '#dc3545'],
        'happy' => ['emoji' => '😊', 'color' => '#ffc107'],
        'angry' => ['emoji' => '😠', 'color' => '#fd7e14'],
        'sad' => ['emoji' => '😢', 'color' => '#6c757d']
    ];

    public function blog()
    {
        return $this->belongsTo(Blogs::class, 'blog_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function getReactionEmoji($type)
    {
        return self::REACTIONS[$type]['emoji'] ?? self::REACTIONS['like']['emoji'];
    }

    public static function getReactionColor($type)
    {
        return self::REACTIONS[$type]['color'] ?? self::REACTIONS['like']['color'];
    }
} 