<?php

namespace App\Mail\Admin;

use App\Models\BlogComment;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class NewBlogCommentNotification extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $comment;

    public function __construct(BlogComment $comment)
    {
        $this->comment = $comment->load(['blog', 'user']);
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'New Comment on Blog - ' . $this->comment->blog->title,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.admin.new-blog-comment',
        );
    }
} 