<?php

namespace App\Mail\Admin;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class LowStockNotification extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $lowStockItems;

    public function __construct(array $lowStockItems)
    {
        $this->lowStockItems = $lowStockItems;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "Stock Alert - Action Required",
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.admin.low-stock',
        );
    }
} 