<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ApiKeyAuth
{
    public function handle(Request $request, Closure $next): Response
    {
        $settings = Setting::singleton();

        if (!$settings->api_enabled) {
            return response()->json(['message' => 'API disabled'], 403);
        }

        $providedKey = $request->header('X-API-KEY')
            ?: $request->query('api_key');

        if (!$settings->api_key || !$providedKey || !hash_equals($settings->api_key, $providedKey)) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        return $next($request);
    }
}





